package itez.tp.impl.tencent;

import java.util.Map;

import com.google.common.collect.Maps;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.sms.v20210111.SmsClient;

import itez.tp.ApiCommon;
import itez.tp.ApiConf;
import itez.tp.ApiCommon.TP;

public abstract class TencentUtil {

	private static Map<Integer, Credential> CRED_CACHE = Maps.newHashMap();
	
	//区域
	public static final String REGION = "ap-beijing";
	//是否国际/港澳台短信：0：表示国内短信，1：表示国际/港澳台短信。
	public static final Long INTERNATIONAL = 0l;
	//短信类型，0表示普通短信, 1表示营销短信。
	public static final Long SMSTYPE = 0l;
	//每个群发批次最多条数
	public static final Integer SEND_BAT_SIZE = 200;
	
	public static Credential getCred(){
		return getCred(ApiCommon.getApi(TP.TENCENT));
	}

	public static Credential getCred(ApiConf api){
		if(!api.getEnable()) return null;
		Integer hash = api.hashCode();
		if(CRED_CACHE.containsKey(hash)){
			return CRED_CACHE.get(hash);
		}else{
			String secretId = api.getVal("secretId");
			String secretKey = api.getVal("secretKey");
			Credential cred = new Credential(secretId, secretKey);			
			CRED_CACHE.put(hash, cred);
			return cred;
		}
	}
	
	public static SmsClient getSmsClient(){
		return getSmsClient(ApiCommon.getApi(TP.TENCENT));
	}

	public static SmsClient getSmsClient(ApiConf api){
		if(!api.getEnable()) return null;
		Credential cred = getCred(api);
		SmsClient client = new SmsClient(cred, REGION);
		return client;
	}
	
	public static String getSmsAppId(){
		return getSmsAppId(ApiCommon.getApi(TP.TENCENT));
	}
	
	public static String getSmsAppId(ApiConf api){
		return api.getVal("smsAppId");
	}
	
}
