package itez.tp.impl.tencent;

import com.tencentcloudapi.sms.v20210111.SmsClient;
import com.tencentcloudapi.sms.v20210111.models.SendSmsRequest;
import com.tencentcloudapi.sms.v20210111.models.SendSmsResponse;
import com.tencentcloudapi.sms.v20210111.models.SendStatus;

import itez.kit.restful.Result;
import itez.tp.ApiCommon;
import itez.tp.ApiConf;
import itez.tp.ApiCommon.TP;

public abstract class SmsUtil {

	/**
	 * 使用默认配置发送单条短信（用于系统提醒）
	 * @param sign
	 * @param tempId
	 * @param phone
	 * @param paras
	 * @return
	 */
	public static Result sendByDef(String sign, String tempId, String phone, String[] paras) {
		String[] phoneArr = new String[]{ phone };
		return sendByDef(sign, tempId, phoneArr, paras);
	}

	/**
	 * 使用默认配置发送多条短信（用于系统提醒）
	 * @param sign
	 * @param tempId
	 * @param phones
	 * @param paras
	 * @return
	 */
	public static Result sendByDef(String sign, String tempId, String[] phones, String[] paras) {
		ApiConf api = ApiCommon.getDefApi(TP.TENCENT);
		SmsClient client = TencentUtil.getSmsClient(api);
		SendSmsRequest req = new SendSmsRequest();
		req.setSmsSdkAppId(TencentUtil.getSmsAppId(api));
		req.setSignName(sign);
		req.setTemplateId(tempId);
		req.setPhoneNumberSet(phones);
		if(paras != null && paras.length > 0) req.setTemplateParamSet(paras);
		try {
			SendSmsResponse res = client.SendSms(req);
			SendStatus statu = res.getSendStatusSet()[0];
			String code = statu.getCode();
			if(code.equalsIgnoreCase("Ok")){
				return Result.success();
			}else{
				return Result.fail(statu.getMessage());
			}
		} catch (Exception e) {
			return Result.fail(e.getMessage());
		}
	}
	
}
