package itez.tp.impl.smtp;

import java.util.Map;

import org.simplejavamail.api.email.ContentTransferEncoding;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.mailer.Mailer;
import org.simplejavamail.api.mailer.config.TransportStrategy;
import org.simplejavamail.email.EmailBuilder;
import org.simplejavamail.mailer.MailerBuilder;

import com.google.common.collect.Maps;

import itez.core.runtime.EContext;
import itez.kit.restful.Result;
import itez.tp.ApiCommon;
import itez.tp.ApiConf;
import itez.tp.ApiCommon.TP;

public class SmtpUtil {
	
	private static Map<Integer, Mailer> MAILER_CACHE = Maps.newHashMap();
	
	/**
	 * 返回发送对象
	 * @param api
	 * @return
	 */
	public static Mailer getMailer(ApiConf api){
		Integer hash = api.hashCode();
		if(MAILER_CACHE.containsKey(hash)){
			return MAILER_CACHE.get(hash);
		}else{
			String server = api.getVal("server");
			String userName = api.getVal("userName");
			String passWord = api.getVal("passWord");
			Integer port = api.getVal("port");
			Boolean ssl = api.getVal("ssl");
			Mailer mailer = MailerBuilder
					.withSMTPServer(server, port, userName, passWord)
					.withTransportStrategy(ssl ? TransportStrategy.SMTP_TLS : TransportStrategy.SMTP)
					.clearEmailValidator()
					.buildMailer();
			MAILER_CACHE.put(hash, mailer);
			return mailer;
		}
	}
	
	public static Result sendMail(String to, String subject, String content){
		return sendMail(ApiCommon.getApi(TP.SMTP), to, subject, content);
	}
	
	public static Result sendMail(ApiConf api, String to, String subject, String content){
		if(!api.getEnable()) return Result.fail("发送邮件的接口已关闭！");
		Mailer mailer = getMailer(api);
		String from = EContext.getAttr().getComp().getCaption();
		Email mail = EmailBuilder.startingBlank()
				.from(from, mailer.getServerConfig().getUsername())
				.to(to)
				.withSubject(subject)
				.withHTMLText(content)
				.withContentTransferEncoding(ContentTransferEncoding.BASE_64)
				.buildEmail();
		try {
			mailer.sendMail(mail);
			return Result.success();
		} catch (Exception e) {
			return Result.fail(e.getMessage());
		}
	}	
}
