package itez.tp.impl.email163;

import java.util.Map;

import com.google.common.collect.Maps;

import itez.kit.EHttp;
import itez.kit.restful.EMap;
import itez.tp.ApiCommon;
import itez.tp.ApiConf;
import itez.tp.ApiCommon.TP;

/**
 * 微信公众号工具类
 * @author netwild
 *
 */
public abstract class Common {

	//接口根地址
	public final static String API_HOST = "https://api.qiye.163.com";
	
	//获取企业下的域名列表
	public final static String GetOrg = "/api/open/org/getOrg";
	
	//获取所有部门列表
	public final static String GetUnitList = "/api/open/unit/getUnitList";
	
	//创建部门
	public final static String CreateUnit = "/api/open/unit/createUnit";
	
	//删除部门
	public final static String DeleteUnit = "/api/open/unit/deleteUnit";
	
	//获取账号详情
	public final static String GetAccount = "/api/open/account/getAccount";
	
	//获取帐号列表
	public final static String GetAccountList = "/api/open/unit/getAccountList";
	
	//创建账户
	public final static String CreateAccount = "/api/open/account/createAccount";
	
	//删除账户（逻辑删除，可恢复）
	public final static String DeleteAccountSim = "/api/open/account/deleteAccountSim";
	
	//恢复账户
	public final static String RecoverAccount = "/api/open/account/recoverAccount";
	
	//冻结账户
	public final static String SuspendAccount = "/api/open/account/suspendAccount";
	
	//删除账户（无法恢复）
	public final static String DeleteAccount = "/api/open/account/deleteAccount";
	
	//更新账户
	public final static String UpdateAccount = "/api/open/account/updateAccount";
	
	//更新密码
	public final static String UpdatePassword = "/api/open/account/updatePassword";
	

	/**
	 * AccessToken服务端缓存
	 */
	private static Map<String, AccessToken> tokenCache = Maps.newConcurrentMap();
	
    public static AccessToken getToken(String key) {
        return tokenCache.get(key);
    }

    public static void setToken(String key, AccessToken jsonValue) {
    	tokenCache.put(key, jsonValue);
    }

    public static void removeToken(String key) {
    	tokenCache.remove(key);
    }
    
    /**
     * 通用请求（自动设置请求头）
     * @param url
     * @param params
     * @return
     */
    @SuppressWarnings("unchecked")
	public static ApiResult query(String url, EMap params){
    	AccessToken accessToken = AccessTokenApi.getAccessToken();
    	String token = accessToken.getAccessToken();
    	ApiConf api = ApiCommon.getApi(TP.EMAIL163);
    	String appId = api.getVal("appId");
    	String orgOpenId = api.getVal("orgOpenId");
    	long timestamp = System.currentTimeMillis();
    	EMap headers = EMap.by("qiye-access-token", token).set("qiye-app-id", appId).set("qiye-org-open-id", orgOpenId).set("qiye-timestamp", "" + timestamp);
    	String json = EHttp.me.postJson(Common.API_HOST.concat(url), params.toJson(), headers);
    	return new ApiResult(json);
    }
	
}
