package itez.tp.impl.email163;

import itez.core.util.RetryUtils;
import itez.kit.EHttp;
import itez.kit.EStr;
import itez.kit.restful.EMap;
import itez.tp.ApiCommon;
import itez.tp.ApiCommon.TP;
import itez.tp.ApiConf;
import java.util.concurrent.Callable;

/**
 * 认证并获取 access_token API
 */
public class AccessTokenApi {

    private static final String AcquireUrl = "/api/pub/token/acquireToken";
    private static final String RefreshUrl = "/api/pub/token/refresh";

    /**
     * 从缓存中获取 access token，如果未取到或者 access token 不可用则先更新再获取
     * @return AccessToken accessToken
     */
    public static AccessToken getAccessToken() {
    	ApiConf api = ApiCommon.getApi(TP.EMAIL163);
    	String appId = api.getVal("appId");
    	if(!api.getEnable()) throw new RuntimeException("第三方接口未启用！");
    	if(EStr.isEmpty(appId)) throw new RuntimeException("还未配置appId！");

    	AccessToken token = Common.getToken(appId);
    	if(token == null){
    		return acquireToken(appId, api);
    	}else if(token.isAccessAvailable()){
    		return token;
    	}else if(token.isRefreshAvailable()){
    		return refreshToken(appId, api);
    	}else{
    		return acquireToken(appId, api);
    	}
    }
    
    private static synchronized AccessToken acquireToken(String appId, ApiConf api) {
        AccessToken token = Common.getToken(appId);
        if (token != null && token.isAccessAvailable()) return token;

    	String authCode = api.getVal("authCode");
    	String orgOpenId = api.getVal("orgOpenId");
        final EMap paras = EMap.by("appId", appId).set("authCode", authCode).set("orgOpenId", orgOpenId);
        token = RetryUtils.retryOnException(3, new Callable<AccessToken>() {
			@Override
            public AccessToken call() throws Exception {
            	String json = EHttp.me.postJson(Common.API_HOST.concat(AcquireUrl), paras.toJson());
            	ApiResult ret = new ApiResult(json);
                return new AccessToken(ret.getData());
            }
        });
        if (null != token) Common.setToken(appId, token);
        return token;
    }
    
    private static synchronized AccessToken refreshToken(String appId, ApiConf api) {
        AccessToken token = Common.getToken(appId);
        if (token != null && token.isAccessAvailable()) return token;

        String refreshToken = token.getRefreshToken();
        final EMap paras = EMap.by("refreshToken", refreshToken);
        token = RetryUtils.retryOnException(3, new Callable<AccessToken>() {
			@Override
            public AccessToken call() throws Exception {
            	String json = EHttp.me.postJson(Common.API_HOST.concat(RefreshUrl), paras.toJson());
            	ApiResult ret = new ApiResult(json);
                return new AccessToken(ret.getData());
            }
        });
        if (null != token) Common.setToken(appId, token);
        return token;
    }

}
