package itez.tp.impl.email163;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;

import itez.core.util.RetryUtils.ResultCheck;
import itez.kit.EDate;
import itez.kit.EJson;

/**
 * 封装 access_token
 */
@SuppressWarnings("unchecked")
public class AccessToken implements ResultCheck, Serializable {
	
	private static final long serialVersionUID = 2013966423232570925L;
	
	private String accessToken;					// 调用凭证(即Access Token)
    private String accessTokenExpiredTime;		// 调用凭证有效期截止，string(date-time)
    private String refreshToken;				// 更新凭证
    private String refreshTokenExpiredTime; 	// 更新凭证有效期截止，string(date-time)

    private Long accessExpiredTime;				// 正确获取到 accessToken 时有值，存放过期时间
    private Long refreshExpiredTime;			// 正确获取到 refreshToken 时有值，存放过期时间
    private String json;

    public AccessToken(String jsonStr) {
        this.json = jsonStr;
        try {
            Map<String, Object> temp = EJson.parse(jsonStr, Map.class);
            accessToken = (String) temp.get("accessToken");
            accessTokenExpiredTime = (String) temp.get("accessTokenExpiredTime");
            refreshToken = (String) temp.get("refreshToken");
            refreshTokenExpiredTime = (String) temp.get("refreshTokenExpiredTime");
            if (accessTokenExpiredTime != null){
            	Date time = EDate.parse(accessTokenExpiredTime);
            	accessExpiredTime = time.getTime();
            }
            if (refreshTokenExpiredTime != null){
            	Date time = EDate.parse(refreshTokenExpiredTime);
            	refreshExpiredTime = time.getTime();
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean matching() {
        return isAccessAvailable();
    }

    @Override
    public String getJson() {
        return json;
    }

    public boolean isAccessAvailable() {
        if (accessExpiredTime == null) return false;
        if (accessExpiredTime < System.currentTimeMillis()) return false;
        return accessToken != null;
    }

    public boolean isRefreshAvailable() {
        if (refreshExpiredTime == null) return false;
        if (refreshExpiredTime < System.currentTimeMillis()) return false;
        return refreshToken != null;
    }

	public String getAccessToken() {
		return accessToken;
	}

	public String getRefreshToken() {
		return refreshToken;
	}
    
}
