package itez.tp.impl.baidu.entity;

import java.io.Serializable;
import java.util.Map;

import itez.core.util.RetryUtils.ResultCheck;
import itez.kit.EJson;

public class AccessToken implements ResultCheck, Serializable {

	private static final long serialVersionUID = -8166253469876586910L;

	private String access_token;    		// 正确获取到 access_token 时有值
    private Integer expires_in;     		// 正确获取到 access_token 时有值
    private String error;       			// 出错时有值
    private String error_description;		// 出错时有值

    private Long expiredTime;				// 正确获取到 access_token 时有值，存放过期时间
    private String json;

    @SuppressWarnings("unchecked")
	public AccessToken(String jsonStr) {
        this.json = jsonStr;
        try {
            Map<String, Object> temp = EJson.parse(jsonStr, Map.class);
            access_token = (String) temp.get("access_token");
            expires_in = (Integer) temp.get("expires_in");
            error = (String) temp.get("error");
            error_description = (String) temp.get("error_description");
            if (expires_in != null) expiredTime = System.currentTimeMillis() + ((expires_in - 5L) * 1000L);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isAvailable() {
        if (expiredTime == null) return false;
        if (error != null) return false;
        if (expiredTime < System.currentTimeMillis()) return false;
        return access_token != null;
    }
    
	@Override
	public boolean matching() {
        return isAvailable();
	}

	public String getAccess_token() {
		return access_token;
	}

	public Integer getExpires_in() {
		return expires_in;
	}

	public String getError() {
		return error;
	}

	public String getError_description() {
		return error_description;
	}

	public Long getExpiredTime() {
		return expiredTime;
	}

	@Override
	public String getJson() {
		return json;
	}
	
}
