package itez.tp.impl.baidu;

import itez.kit.EHttp;
import itez.tp.impl.baidu.entity.AccessToken;
import itez.tp.impl.baidu.entity.Params;
import itez.tp.impl.baidu.entity.Result;

/**
 * 百度云OCR文字识别API
 * @author netwild
 */
public class ApiKit {

	/**
	 * 通用文字识别
	 * @param params
	 * @return
	 */
	public static Result general_basic(Params params){
		String url = "https://aip.baidubce.com/rest/2.0/ocr/v1/general_basic";
		String json = EHttp.me.postForm(format(url), params.parse());
		return new Result(json);
	}

	/**
	 * 通用文字识别（高精度版）
	 * @param params
	 * @return
	 */
	public static Result accurate_basic(Params params){
		String url = "https://aip.baidubce.com/rest/2.0/ocr/v1/accurate_basic";
		String json = EHttp.me.postForm(format(url), params.parse());
		return new Result(json);
	}

	/**
	 * 通用文字识别（含位置信息版）
	 * @param params
	 * @return
	 */
	public static Result general(Params params){
		String url = "https://aip.baidubce.com/rest/2.0/ocr/v1/general";
		String json = EHttp.me.postForm(format(url), params.parse());
		return new Result(json);
	}

	/**
	 * 通用文字识别（高精度含位置版）
	 * @param params
	 * @return
	 */
	public static Result accurate(Params params){
		String url = "https://aip.baidubce.com/rest/2.0/ocr/v1/accurate";
		String json = EHttp.me.postForm(format(url), params.parse());
		return new Result(json);
	}
	
	/**
	 * 数字识别
	 * @param params
	 * @return
	 */
	public static Result numbers(Params params){
		String url = "https://aip.baidubce.com/rest/2.0/ocr/v1/numbers";
		String json = EHttp.me.postForm(format(url), params.parse());
		return new Result(json);
	}
	
	/**
	 * 手写文字识别
	 * @param params
	 * @return
	 */
	public static Result handwriting(Params params){
		String url = "https://aip.baidubce.com/rest/2.0/ocr/v1/handwriting";
		String json = EHttp.me.postForm(format(url), params.parse());
		return new Result(json);
	}
	
	/**
	 * 表格文字识别(同步接口)
	 * @param params
	 * @return
	 */
	public static Result form(Params params){
		String url = "https://aip.baidubce.com/rest/2.0/ocr/v1/form";
		String json = EHttp.me.postForm(format(url), params.parse());
		return new Result(json);
	}
	
	/**
	 * 表格文字识别(异步接口：提交请求)
	 * @param params
	 * @return
	 */
	public static Result form_request(Params params){
		String url = "https://aip.baidubce.com/rest/2.0/ocr/v1/form_ocr/request";
		String json = EHttp.me.postForm(format(url), params.parse());
		return new Result(json);
	}
	
	/**
	 * 表格文字识别(异步接口：获取结果)
	 * @param params
	 * @return
	 */
	public static Result form_result(Params params){
		String url = "https://aip.baidubce.com/rest/2.0/ocr/v1/form_ocr/get_request_result";
		String json = EHttp.me.postForm(format(url), params.parse());
		return new Result(json);
	}
	
	/**
	 * iOCR自定义模板文字识别
	 * @param params
	 * @return
	 */
	public static Result iocr(Params params){
		String url = "https://aip.baidubce.com/rest/2.0/solution/v1/iocr/recognise";
		String json = EHttp.me.postForm(format(url), params.parse());
		return new Result(json);
	}
	
	//////////////////// 私有方法 //////////////////////////////////////////////////////////////////////
	
	/**
	 * 格式化请求地址
	 * @param url
	 * @return
	 */
	private static String format(String url){
		AccessToken token = AccessTokenKit.getAccessToken();
		return String.format("%s?access_token=%s", url, token.getAccess_token());
	}
	
}
