package itez.tp.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

import itez.kit.EJson;

/**
 * 返回值抽象类
 * @author netwild
 *
 */
public class BaseResult {

    protected Map<String, Object> attrs;
    protected String json;
    

    /**
     * 通过 json 构造 ApiResult，注意返回结果不为 json 的 api（如果有的话）
     * @param jsonStr json字符串
     */
    @SuppressWarnings("unchecked")
    public BaseResult(String jsonStr) {
        this.json = jsonStr;
        try {
            Map<String, Object> temp = EJson.parse(jsonStr, Map.class);
            this.attrs = temp;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 通过 json 创建 ApiResult 对象，等价于 new ApiResult(jsonStr)
     * @param jsonStr json字符串
     * @return {ApiResult}
     */
    public static BaseResult create(String jsonStr) {
        return new BaseResult(jsonStr);
    }

    public String getJson() {
        return json;
    }

    public String toString() {
        return getJson();
    }
    
    @SuppressWarnings("unchecked")
    public <T> T get(String name) {
        return (T)attrs.get(name);
    }

    public String getStr(String name) {
        return (String)attrs.get(name);
    }

    public Integer getInt(String name) {
        Number number = (Number) attrs.get(name);
        return number == null ? null : number.intValue();
    }

    public Long getLong(String name) {
        Number number = (Number) attrs.get(name);
        return number == null ? null : number.longValue();
    }

    public BigInteger getBigInteger(String name) {
        return (BigInteger)attrs.get(name);
    }

    public Double getDouble(String name) {
        return (Double)attrs.get(name);
    }

    public BigDecimal getBigDecimal(String name) {
        return (BigDecimal)attrs.get(name);
    }

    public Boolean getBoolean(String name) {
        return (Boolean)attrs.get(name);
    }

    @SuppressWarnings("rawtypes")
    public List getList(String name) {
        return (List)attrs.get(name);
    }

    @SuppressWarnings("rawtypes")
    public Map getMap(String name) {
        return (Map)attrs.get(name);
    }
    
}
