package itez.tp;

import java.util.Set;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;

import itez.kit.EFile;
import itez.kit.ELog;
import itez.kit.EStr;
import itez.kit.log.ELogBase;
import itez.plat.main.model.TpApi;
import itez.tp.ApiCommon.MODE;

public class Loader {

	private String code;
	private String caption;

	private String summary = null;
	private String cols = null;
	private String defs = null;
	
	private boolean proxyAble = false;
	private boolean shareAble = false;

	private Set<String> fields = Sets.newHashSet();
	private Set<String> secrets = Sets.newHashSet();
		
	private static ELogBase log = ELog.log(Loader.class);
		
	public Loader(String code, String caption) {
		this.code = code;
		this.caption = caption;
		this.init();
	}
	
	private void init(){
		String cfgPath = "itez/tp/conf/" + code + ".json";
		String cfgJson = EFile.readInJar(cfgPath);
		if(EStr.isEmpty(cfgJson)){
			log.error("加载第三方配置文件失败！" + cfgPath);
			return;
		}
		JSONObject cfg = JSON.parseObject(cfgJson);
		summary = cfg.getString("summary");
		proxyAble = cfg.getBooleanValue("proxyAble");
		shareAble = cfg.getBooleanValue("shareAble");
		defs = cfg.getString("defs");
		JSONArray colsArr = cfg.getJSONArray("cols");
		for(int i = 0, l = colsArr.size(); i < l; i++){
			JSONObject col = colsArr.getJSONObject(i);
			String field = col.getString("field");
			String type = EStr.ifEmpty(col.getString("type"), "text");
			fields.add(field);
			if(type.equalsIgnoreCase("password")) secrets.add(field);
		}
		cols = colsArr.toJSONString();
	}
	
	public TpApi parseApi(TpApi api){
		if(null == api){
			api = new TpApi();
			api.setCode(code).setCaption(caption);
			api.setEnable(proxyAble || shareAble);
			api.setMode(proxyAble ? MODE.proxy.name() : shareAble ? MODE.share.name() : MODE.own.name());
			api.setData(shareAble ? defs : null);
		}else if(!api.getMode().equals(MODE.own.name())){
			api.setData(defs);
		}
		return api;
	}
	
	public String getCode() {
		return code;
	}
	public String getCaption() {
		return caption;
	}
	public String getSummary() {
		return summary;
	}
	public String getCols() {
		return cols;
	}
	public String getDefs() {
		return defs;
	}
	public Set<String> getFields() {
		return fields;
	}
	public Set<String> getSecrets() {
		return secrets;
	}
	public Boolean proxyAble() {
		return proxyAble;
	}
	public Boolean shareAble() {
		return shareAble;
	}
	
}
