package itez.tp;

import itez.core.runtime.service.Ioc;
import itez.plat.main.service.TpApiService;

public abstract class ApiCommon {

	/**
	 * 第三方平台枚举
	 * 
	 * 原微信开放平台：OP => WXOP
	 * 原微信公众平台：MP => WXMP
	 * 原微哨开放平台：WSOA => WSOP
	 * 
	 * @author netwild
	 *
	 */
	public static enum TP {
    	WXMP("微信公众平台"),
    	WXOP("微信开放平台"),
    	WXAP("微信小程序"),
    	WXEP("微信企业号"),
    	TENCENT("腾讯云"),
    	ALI("阿里云"),
    	BAIDU("百度云"),
    	SMTP("发送邮件"),
    	EMAIL163("网易企业邮箱"),
    	WSOP("微哨开放平台");
    	private String caption;
    	private Loader loader;
    	TP(String caption){
			this.caption = caption;
			this.loader = new Loader(this.name(), caption);
		}
		public String getCaption(){
			return caption;
		}
		public Loader getLoader(){
			return loader;
		}
	}
	
	/**
	 * 引用模式
	 * @author netwild
	 *
	 */
	public static enum MODE {
		proxy,    //云端代理
		share,    //本地共享
		own       //自有账号
	}

	/**
	 * 用户来源
	 * @author netwild
	 *
	 */
	public static enum USR_SOURCE {
		MGR,	  //后台添加
		REG,      //普通注册
		WEIXIN,   //微信注册
		WEISHAO;  //微哨注册
		public static boolean containsKey(String key){
			for (USR_SOURCE e: USR_SOURCE.values()){
	            if(e.name().equals(key)) return true;
	        }
			return false;
		}
	};
	
	/**
	 * 返回当前子域的接口配置数据
	 * @param tp
	 * @return
	 */
	public static ApiConf getApi(TP tp){
		TpApiService ser = Ioc.get(TpApiService.class);
		return ser.getApi(tp);
	}
	
	/**
	 * 返回默认的接口配置数据
	 * @param tp
	 * @return
	 */
	public static ApiConf getDefApi(TP tp){
		TpApiService ser = Ioc.get(TpApiService.class);
		return ser.getDefApi(tp);
	}
	
}
