package itez.plat.wrapper.launch;

import com.jfinal.config.Constants;
import com.jfinal.config.Interceptors;
import com.jfinal.config.Plugins;
import com.jfinal.template.Engine;

import itez.core.launch.JWinnerConfig;
import itez.core.runtime.service.Ioc;
import itez.kit.EProp;
import itez.kit.terminal.TerminalUtil;
import itez.plat.main.service.ModuleService;
import itez.plat.main.service.TaskService;
import itez.plat.main.util.ConfigKit;

/**
 * 平台项目[plat] 初始化配置文件
 * 
 * @author netwild
 *
 */
public class PlatConfig extends JWinnerConfig {

	/**
	 * 全局参数配置
	 */
	@Override
	public void configConstant(Constants me) {
		super.configConstant(me);
	}
	
	/**
	 * 模板引擎配置
	 */
	@Override
	public void configEngine(Engine me) {
		super.configEngine(me);
		me.addSharedFunction(EProp.TempLayoutPath + "/layout_base.html");
		me.addSharedFunction(EProp.TempLayoutPath + "/layout_main.html");
		me.addSharedFunction(EProp.TempLayoutPath + "/layout_mgr.html");
		me.addSharedFunction(EProp.TempLayoutPath + "/pageHeader.html");
		me.addSharedFunction(EProp.TempLayoutPath + "/pageMenu.html");
		me.addSharedObject("PropUtil", new EProp());
		me.addSharedObject("ConfigUtil", new ConfigKit());
	}
	
	/**
	 * 拦截器配置
	 */
	@Override
	public void configInterceptor(Interceptors me) {
		super.configInterceptor(me);
	}
	
	@Override
	public void configPlugin(Plugins me) {
		super.configPlugin(me);
	}
	
	/**
	 * 启动完成后运行
	 */
	@Override
	public void onStart() {
		super.onStart();

		//每次启动服务器后，自动同步模块配置数据
		ModuleService moduleSer = Ioc.get(ModuleService.class);
		moduleSer.initModuleData();
		
		if(EProp.TerminalSupport){
			//终端启动时自动签到
			TerminalUtil.checkIn();
		}
		
		if(EProp.EnableCronTask){
			//每次启动服务器后，自动开启定时任务列表
			TaskService taskSer = Ioc.get(TaskService.class);
			taskSer.initTaskData();
		}
		
	}

}
