package itez.plat.wrapper.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;

import itez.core.runtime.auth.AuthCode;
import itez.core.runtime.service.Ioc;
import itez.core.wrapper.controller.EController;
import itez.plat.main.service.MenuService;

public class MenuInterceptor implements Interceptor {
	
	MenuService menuSer = Ioc.get(MenuService.class);
	
	@Override
	public void intercept(Invocation inv) {
		if(!menuSer.interceptorMenu(inv, "menu")){
			EController controller  = (EController)inv.getController();
			controller.renderErrMsg(AuthCode.REQ_LICENSE, "当前模块未授权");
			return;
		}
		inv.invoke();
	}

}
