package itez.plat.wrapper.controller;

import com.jfinal.aop.Clear;

import itez.core.runtime.auth.AuthRequire;
import itez.core.runtime.service.common.IUser;
import itez.core.wrapper.controller.EController;
import itez.kit.restful.Result;

@AuthRequire.Logined
public abstract class EControllerAuth extends EController {

	/**
	 * 获取Token
	 */
	@Clear
	public void getToken(){
		String token = session().getToken();
		renderJson(Result.success("token", token));
	}

	/**
	 * 校验Token是否已登录
	 */
	@Clear
	public void valiToken(){
		boolean logined = session().getLogined();
		IUser user = session().getUser();
		if(logined) renderJson(Result.success("user", user));
		else renderJson(Result.fail());
	}
	
}
