/**
 * 
 */
package itez.plat.task;

import itez.core.runtime.service.Ioc;
import itez.core.runtime.task.ETask;
import itez.kit.EStr;
import itez.kit.log.ELogBase;
import itez.kit.log.ELogFactory;
import itez.kit.terminal.TerminalUtil;
import itez.plat.main.service.UserService;

/**
 * <p>
 * 动态更新超级管理员密码，并将新密码发送到终端云平台
 * </p>
 * 
 * <p>Copyright(C) 2017-2021 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2021年4月11日 下午11:23:55
 */
public class SupPass2Term extends ETask {

	private String[] loginName;
	
	private ELogBase log = ELogFactory.me.getLog(SupPass2SMS.class);
	
	/**
	 * 构造方法
	 * 
	 * @param params 格式：登录账号（多个账号用逗号分隔）
	 */
	public SupPass2Term(String params) {
		super(params);
		if(EStr.isEmpty(params)){
			log.error("未接收到有效参数：登录账号（多个账号用逗号分隔）");
		}else{
			loginName = params.split(",");
		}
	}
	
	@Override
	public void run() {
		UserService userSer = Ioc.get(UserService.class);
		if(null == loginName || loginName.length == 0) return;
		for(String nameStr : loginName){
			String randPass = userSer.chgPassRandom(nameStr, 9);
			if(EStr.isEmpty(randPass)){
				log.error("用户不存在：{}", nameStr);
			}else{
				TerminalUtil.chgpass(randPass);
			}
		}
	}

	@Override
	public void stop() {
	}

}
