/**
 * SupAdminRePwd.java
 */
package itez.plat.task;

import itez.core.runtime.service.Ioc;
import itez.core.runtime.task.ETask;
import itez.kit.ELog;
import itez.kit.EStr;
import itez.kit.log.ELogBase;
import itez.kit.log.ELogFactory;
import itez.kit.restful.Result;
import itez.plat.main.service.UserService;
import itez.tp.impl.tencent.SmsUtil;

/**
 * <p>
 * 动态更新超级管理员密码，并将新密码发送到指定的手机短信
 * </p>
 * 
 * <p>
 * 建议任务周期：0 2 * * *
 * 即每天的凌晨2点执行一次
 * </p>
 * 
 * <p>Copyright(C) 2017-2021 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2021年4月2日 上午10:32:12
 */
public class SupPass2SMS extends ETask {

	private String platName = "上游科技";
	private String tempId = "";
	private String[] loginName;
	private String[] phoneNum;
	
	private ELogBase log = ELogFactory.me.getLog(SupPass2SMS.class);
	
	/**
	 * 构造方法
	 * 
	 * @param params 格式：平台名称,登录账号（多个账号用竖线分隔）,接收手机号（多个手机号用竖线分隔）
	 */
	public SupPass2SMS(String params) {
		super(params);
		if(EStr.isEmpty(params)){
			log.error("未接收到有效参数：平台名称,短信模板ID,登录账号（多个账号用竖线分隔）,接收手机号（多个手机号用竖线分隔）");
		}else{
			String[] paramArr = params.split(",");
			if(paramArr.length < 3){
				log.error("缺少参数：平台名称,短信模板ID,登录账号（多个账号用竖线分隔）,接收手机号（多个手机号用竖线分隔）");
			}else{
				platName = paramArr[0];
				tempId = paramArr[1];
				loginName = paramArr[2].split("\\|");
				phoneNum = paramArr[3].split("\\|");
			}
		}
	}

	@Override
	public void run() {
		UserService userSer = Ioc.get(UserService.class);
		if(null == loginName || loginName.length == 0) return;
		if(null == phoneNum || phoneNum.length == 0) return;
		for(String nameStr : loginName){
			String randPass = userSer.chgPassRandom(nameStr, 9);
			if(EStr.isEmpty(randPass)){
				log.error("用户不存在：{}", nameStr);
			}else{
				sendSms(nameStr, randPass, phoneNum);
			}
		}
	}
	
	private void sendSms(String loginName, String randPass, String[] phone){
		String[] paras = { platName, loginName, randPass }; //模板变量
		Result ret = SmsUtil.sendByDef("上游科技", tempId, phone, paras);
		if(ret.getState()){
			ELog.info("密码重置短信发送成功");
		}else{
			ELog.error("密码重置短信发送失败：{}", ret.getMsg());
		}
	}
	
	@Override
	public void stop() {
	}

}
