/**
 * WebSocketEncode.java
 */
package itez.plat.socket.websocket;

import javax.websocket.EncodeException;
import javax.websocket.Encoder;
import javax.websocket.EndpointConfig;

import itez.kit.EJson;

/**
 * <p>
 * WebSocket编码器（JSON）
 * </p>
 * 
 * <p>Copyright(C) 2017-2020 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2020年10月18日 下午2:08:29
 */
public class WebSocketJsonEncode implements Encoder.Text<SocketMsg> {

	@Override
	public void init(EndpointConfig config) {
	}

	@Override
	public void destroy() {
	}

	@Override
	public String encode(SocketMsg object) throws EncodeException {
		return EJson.toJson(object);
	}

}
