/**
 * 
 */
package itez.plat.socket.websocket;

import java.io.IOException;

import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;

import itez.kit.ELog;
import itez.kit.EProp;
import itez.kit.log.ELogBase;
import itez.plat.socket.model.Tokens;

/**
 * <p>
 * WebSocket类
 * </p>
 * 
 * <p>Copyright(C) 2017-2020 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2020年10月17日 下午9:38:40
 */
@ServerEndpoint(value="/client/ws/{token}")
public class WebSocketController {

	private ELogBase log = ELog.log(WebSocketController.class);
	
	@OnOpen
	public void onOpen(Session session, EndpointConfig conf, @PathParam("token") String token) throws IOException{
		Tokens tokens = WebSocketFactory.getToken(token);
		if(tokens == null){
			session.close(new CloseReason(CloseReason.CloseCodes.CANNOT_ACCEPT, "Invalid Token"));
			return;
		}
		int cnt = WebSocketFactory.online(session, tokens);
		log.debug("新连接加入：{}，当前在线人数为：{}", session.getId(), cnt);
    }
	
	@OnClose
	public void onClose(Session session, CloseReason reason, @PathParam("token") String token){
		Tokens tokens = WebSocketFactory.getToken(token);
		int cnt = WebSocketFactory.offline(session, tokens);
		log.debug("连接断开：{}，当前在线人数为：{}", session.getId(), cnt);
	}
	
	@OnMessage
	public void onMessage(Session session, String message, @PathParam("token") String token) {
		Tokens tokens = WebSocketFactory.getToken(token);
		WebSocketFactory.onMessage(session, tokens, message);
		log.debug("来自客户端的消息：{}", message);
	}
	
	@OnError
	public void onError(Session session, Throwable error, @PathParam("token") String token){
		Tokens tokens = WebSocketFactory.getToken(token);
		WebSocketFactory.onError(session, tokens, error);
		log.error("发生错误，来自：{}", session.getId());
		if(EProp.DevMode) error.printStackTrace();
	}
	
}
