/**
 * SocketServiceDef.java
 */
package itez.plat.socket.websocket;

import com.esotericsoftware.minlog.Log;

import itez.kit.EStr;
import itez.plat.socket.model.Tokens;

/**
 * <p>
 * 默认通道处理（DefaultChannel）
 * </p>
 * 
 * <p>Copyright(C) 2017-2020 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2020年10月20日 上午10:17:20
 */
public class SocketServiceDef implements ISocketService {

	@Override
	public void online(Tokens token, SocketClient client) {
		String sid = token.getSid();
		SocketMsg msg = new SocketMsg(sid, "*", "欢迎新用户上线：" + token.getUname());
		msg.setOnline().set("sid", sid).set("uid", token.getUid()).set("uname", token.getUname());
		WebSocketFactory.sendMessage(msg);
	}

	@Override
	public void offline(Tokens token, SocketClient client) {
		String sid = token.getSid();
		SocketMsg msg = new SocketMsg(sid, "*", "用户已离线：" + token.getUname());
		msg.setOffline().set("sid", sid).set("uid", token.getUid()).set("uname", token.getUname());
		WebSocketFactory.sendMessage(msg);
	}

	@Override
	public void onMessage(SocketClient fromClient, SocketMsg msg) {
		String toId = msg.getToId();
		if(EStr.isEmpty(toId)){
			Log.error("未指定接收者");
		}else{
			WebSocketFactory.sendMessage(msg);
		}
	}

	@Override
	public void onError(Tokens token, SocketClient client, Throwable error) {
	}

}
