/**
 * SocketMsg.java
 */
package itez.plat.socket.websocket;

import itez.kit.EJson;
import itez.kit.EStr;
import itez.kit.restful.EMap;

/**
 * <p>
 * 消息内容封装
 * </p>
 * 
 * <p>Copyright(C) 2017-2020 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2020年10月18日 下午2:09:39
 */
public class SocketMsg extends EMap {

	private static final long serialVersionUID = -3920488917539094115L;
	
	private static enum TYPES { TEXT, IMAGE, FILE }
	private static enum EVENT { ONLINE, OFFLINE, PING, PONG }
	
	private static final String ATTR_FROM = "fromId";
	private static final String ATTR_TO = "toId";
	private static final String ATTR_TYPE = "type";
	private static final String ATTR_CONT = "content";
	private static final String ATTR_EVENT = "event";
	
	String message = null;
	
	public static SocketMsg parse(String fromId, String message) {
		if(EStr.isEmpty(message)) return null;
		return new SocketMsg(fromId, message);
	}
	
	private SocketMsg(String fromId, String message){
		if(EStr.isEmpty(message)) return;
		this.message = message;
		EMap data = EJson.parse(message, EMap.class);
		if(data != null) set(data);
		if(EStr.isEmpty(get(ATTR_TYPE))) set(ATTR_TYPE, TYPES.TEXT.name());
		if(EStr.notEmpty(fromId)) set("fromId", fromId);
	}
	
	public SocketMsg(String fromId, String toId, String content){
		set(ATTR_FROM, fromId);
		set(ATTR_TO, toId);
		set(ATTR_TYPE, TYPES.TEXT.name());
		set(ATTR_CONT, content);
	}
	
	@Override
	public String toString(){
		return EJson.toJson(this);
	}
	
	public boolean isPingPong(){
		EVENT evt = getEventEnum();
		if(evt == null) return false;
		return evt == EVENT.PING || evt == EVENT.PONG;
	}
	
	public SocketMsg setOnline(){
		set(ATTR_EVENT, EVENT.ONLINE.name());
		return this;
	}
	
	public SocketMsg setOffline(){
		set(ATTR_EVENT, EVENT.OFFLINE.name());
		return this;
	}
	
	public SocketMsg setPing(){
		set(ATTR_EVENT, EVENT.PING.name());
		return this;
	}
	
	public SocketMsg setPong(){
		set(ATTR_EVENT, EVENT.PONG.name());
		return this;
	}
	
	public SocketMsg setEvent(EVENT evt){
		set(ATTR_EVENT, evt);
		return this;
	}
	
	public EVENT getEventEnum(){
		String event = getStr(ATTR_EVENT);
		if(EStr.isEmpty(event)) return null;
		return EVENT.valueOf(event);
	}

	public String getFromId() {
		return getStr(ATTR_FROM);
	}

	public String getToId() {
		return getStr(ATTR_TO);
	}

	public String getType() {
		return getStr(ATTR_TYPE);
	}

	public String getContent() {
		return getStr(ATTR_CONT);
	}

	public String getMessage() {
		return message;
	}
	
}
