/**
 * SocketClient.java
 */
package itez.plat.socket.websocket;

import java.io.IOException;
import java.util.Date;

import javax.websocket.Session;

import itez.kit.EDate;
import itez.kit.ELog;
import itez.kit.EProp;
import itez.kit.log.ELogBase;
import itez.plat.socket.model.Tokens;

/**
 * <p>
 * 类描述
 * </p>
 * 
 * <p>Copyright(C) 2017-2020 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2020年10月18日 下午3:29:33
 */
public class SocketClient {

	private ELogBase log = ELog.log(SocketClient.class);
	
	private Tokens token;
	private String domain;
	private String channel;
	private String uid;
	private String uname;
	private Session session;
	private String sid;
	private Date pingDate;
	
	public SocketClient(Tokens token, Session session) {
		this.token = token;
		this.domain = token.getDomain();
		this.channel = token.getChannel();
		this.uid = token.getUid();
		this.uname = token.getUname();
		this.sid = session.getId();
		this.session = session;
		updatePing();
	}
	
	/**
	 * <p>
	 * 向当前会话发送消息
	 * </p>
	 * 
	 * @param msg
	 */
	public void sendMessage(SocketMsg msg){
		try {
			String msgStr = msg.toString();
			session.getBasicRemote().sendText(msgStr);
		} catch (IOException e) {
			log.error("发送消息发送错误");
			if(EProp.DevMode) e.printStackTrace();
		}
	}
	
	/**
	 * <p>
	 * 返回当前会话是否正常
	 * </p>
	 * 
	 * @return
	 */
	public boolean isOpen(){
		return session.isOpen();
	}
	
	/**
	 * <p>
	 * 返回当前会话是否是基于安全连接（WSS）
	 * </p>
	 * 
	 * @return
	 */
	public boolean isSecure(){
		return session.isSecure();
	}
	
	/**
	 * <p>
	 * 更新最后通信时间
	 * </p>
	 *
	 */
	public void updatePing(){
		this.pingDate = EDate.getDate();
	}

	/**
	 * <p>
	 * 返回当前会话的通信令牌
	 * </p>
	 * 
	 * @return
	 */
	public Tokens getToken() {
		return token;
	}

	public String getDomain() {
		return domain;
	}

	public String getChannel() {
		return channel;
	}

	public String getUid() {
		return uid;
	}

	public String getUname() {
		return uname;
	}

	public String getSid() {
		return sid;
	}

	public Session getSession() {
		return session;
	}

	public Date getPingDate() {
		return pingDate;
	}
	
}
