/**
 * ISocketService.java
 */
package itez.plat.socket.websocket;

import itez.plat.socket.model.Tokens;

/**
 * <p>
 * WebSocket通道处理接口
 * 在方法实现中，可随时调用 “WebSocketFactory”中的静态方法实现消息相关的操作。
 * </p>
 * 
 * <p>Copyright(C) 2017-2020 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2020年10月20日 上午9:49:29
 */
public interface ISocketService {
	
	/**
	 * <p>
	 * 新用户上线
	 * </p>
	 * 
	 * @param token 通信令牌
	 * @param client 客户端对象封装，其中含有会话session
	 */
	public void online(Tokens token, SocketClient client);

	/**
	 * <p>
	 * 用户离线
	 * </p>
	 * 
	 * @param token 通信令牌
	 * @param client 客户端对象封装，其中含有会话session
	 */
	public void offline(Tokens token, SocketClient client);
	
	/**
	 * <p>
	 * 新消息
	 * </p>
	 * 
	 * @param msg
	 */
	public void onMessage(SocketClient fromClient, SocketMsg msg);
	
	/**
	 * <p>
	 * 发生错误
	 * </p>
	 * 
	 * @param client
	 * @param error
	 */
	public void onError(Tokens token, SocketClient client, Throwable error);

}
