/**
 * HeartCheck.java
 */
package itez.plat.socket.websocket;

import java.io.IOException;
import java.util.Date;
import java.util.List;

import javax.websocket.CloseReason;

import itez.kit.EDate;
import itez.kit.ELog;
import itez.kit.EProp;
import itez.kit.log.ELogBase;
import itez.plat.socket.model.Tokens;

/**
 * <p>
 * 类描述
 * </p>
 * 
 * <p>Copyright(C) 2017-2020 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2020年10月20日 下午3:37:06
 */
public class HeartCheck extends Thread {
	
	private static ELogBase log = ELog.log(HeartCheck.class);

	long timeout = 10 * 60 * 1000; //超时
	boolean runAble = false;
	
	@Override
	public void run() {
		while(runAble){
			Date now = EDate.getDate();
			log.debug("开始执行定期自动清理：{}", now);
			List<Tokens> tokens = WebSocketFactory.tokenSer.getOnLineTokens();
			tokens.forEach(t -> {
				String sid = t.getSid();
				SocketClient client = WebSocketFactory.getClient(sid);
				if(client == null || EDate.diff(client.getPingDate(), now).toMillis() > timeout){
					WebSocketFactory.tokenSer.offline(t);
					if(client != null){
						WebSocketFactory.removeClientCache(sid);
						WebSocketFactory.subOnlineCount();
						try {
							client.getSession().close(new CloseReason(CloseReason.CloseCodes.GOING_AWAY, "Timeout"));
						} catch (IOException e) {}
					}
					log.debug("清理超时用户：{}", sid);
				}
			});
			try {
				sleep(timeout);
			} catch (InterruptedException e) {
				this.runAble = false;
				if(EProp.DevMode) e.printStackTrace();
			}
		}
	}

	public synchronized boolean isRunAble() {
		return runAble;
	}

	public synchronized void setRunAble(boolean runAble) {
		this.runAble = runAble;
	}
	
}
