package itez.plat.socket.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.runtime.service.common.IUser;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EDate;
import itez.kit.EStr;
import itez.core.runtime.service.Define;
import itez.plat.socket.model.Tokens;
import itez.plat.socket.service.TokensService;
import itez.plat.socket.websocket.WebSocketFactory;

import java.util.List;

import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class TokensServiceImpl extends EModelService<Tokens> implements TokensService {
	
	@Override
	public Tokens getToken(String tokenId) {
		Querys qs = Querys.and(Query.eq("id", tokenId));
		return selectFirst(qs, null, false);
	}

	////////////////////////////////////////////////////////////////////////////////
	
	@Override
	public Tokens getMyToken() {
		return getMyToken(null);
	}

	@Override
	public Tokens getMyToken(String channel) {
		if(EStr.isEmpty(channel)) channel = WebSocketFactory.DEF_CHANNEL;
		Querys qs = Querys.and(Query.eq("uid", $uid())).add(Query.eq("channel", channel));
		return selectFirst(qs);
	}

	////////////////////////////////////////////////////////////////////////////////

	@Override
	public List<Tokens> getOnLineTokens() {
		Querys qs = Querys.and(Query.eq("state", true));
		return select(qs, null, null, false);
	}

	////////////////////////////////////////////////////////////////////////////////

	@Override
	public List<Tokens> getTokenByChannel() {
		return getTokenByChannel(null);
	}

	@Override
	public List<Tokens> getTokenByChannel(String channel) {
		return getTokenByChannel($domain(), channel);
	}

	@Override
	public List<Tokens> getTokenByChannel(String domain, String channel) {
		return getTokensByChannel(domain, channel, true);
	}

	////////////////////////////////////////////////////////////////////////////////

	@Override
	public List<Tokens> getAllTokenByChannel() {
		return getAllTokenByChannel(null);
	}

	@Override
	public List<Tokens> getAllTokenByChannel(String channel) {
		return getAllTokenByChannel($domain(), channel);
	}

	@Override
	public List<Tokens> getAllTokenByChannel(String domain, String channel) {
		return getTokensByChannel(domain, channel, null);
	}

	////////////////////////////////////////////////////////////////////////////////
	
	private List<Tokens> getTokensByChannel(String domain, String channel, Boolean state){
		if(EStr.isEmpty(domain)) return null;
		if(EStr.isEmpty(channel)) channel = WebSocketFactory.DEF_CHANNEL;
		Querys qs = Querys.and(Query.eq("domain", domain)).add(Query.eq("channel", channel));
		if(state != null) qs.add(Query.eq("state", state));
		return select(qs, null, null, false);
	}

	////////////////////////////////////////////////////////////////////////////////

	@Override
	public void online(Tokens token, String sid) {
		token.setSid(sid);
		token.setOnDate(EDate.getDate());
		token.setState(true);
		update(token);
	}

	@Override
	public void offline(Tokens token) {
		token.setOffDate(EDate.getDate());
		token.setState(false);
		update(token);
	}

	@Override
	public void offline(String tokenId) {
		Tokens token = getToken(tokenId);
		token.setOffDate(EDate.getDate());
		token.setState(false);
		update(token);
	}

	////////////////////////////////////////////////////////////////////////////////

	@Override
	public Tokens createToken() {
		return createToken(null);
	}

	@Override
	public Tokens createToken(String channel) {
		if(EStr.isEmpty(channel)) channel = WebSocketFactory.DEF_CHANNEL;
		Tokens token = getMyToken(channel);
		if(token != null) return token;
		token = new Tokens();
		IUser user = $user();
		token.setUid(user.getId());
		token.setUname(user.getCaption());
		token.setChannel(channel);
		token.setState(false);
		save(token);
		return token;
	}

}