package itez.plat.socket.service;

import java.util.List;

import itez.core.runtime.service.IModelService;
import itez.plat.socket.model.Tokens;

/**
 * 由JWinner Service Generator自动生成。
 */
public interface TokensService extends IModelService<Tokens>{

	/**
	 * <p>
	 * 根据tokenId返回token对象
	 * </p>
	 * 
	 * @param tokenId
	 * @return
	 */
	Tokens getToken(String tokenId);

	////////////////////////////////////////////////////////////////////////////////
	
	/**
	 * <p>
	 * 返回当前用户的token对象（默认通道）
	 * </p>
	 * 
	 * @param uid
	 * @return
	 */
	Tokens getMyToken();
	
	/**
	 * <p>
	 * 返回当前用户的token对象
	 * </p>
	 * 
	 * @param uid
	 * @return
	 */
	Tokens getMyToken(String channel);

	////////////////////////////////////////////////////////////////////////////////
	
	/**
	 * <p>
	 * 返回在线token列表（全部子域、全部通道）
	 * 仅用于心跳检测，禁止外部调用
	 * </p>
	 * 
	 * @return
	 */
	List<Tokens> getOnLineTokens();

	////////////////////////////////////////////////////////////////////////////////
	
	/**
	 * <p>
	 * 返回默认通道的在线token列表
	 * </p>
	 * 
	 * @return
	 */
	List<Tokens> getTokenByChannel();
	
	/**
	 * <p>
	 * 返回指定通道的在线token列表
	 * </p>
	 * 
	 * @param channel
	 * @return
	 */
	List<Tokens> getTokenByChannel(String channel);
	
	/**
	 * <p>
	 * 返回指定通道的在线token列表
	 * 主要用于webSocket控制器端群发，需要特别指定domain
	 * </p>
	 * 
	 * @param domain 子域
	 * @param channel
	 * @return
	 */
	List<Tokens> getTokenByChannel(String domain, String channel);

	////////////////////////////////////////////////////////////////////////////////
	
	/**
	 * <p>
	 * 返回默认通道的token列表，包含离线用户
	 * </p>
	 * 
	 * @param channel
	 * @return
	 */
	List<Tokens> getAllTokenByChannel();
	
	/**
	 * <p>
	 * 返回指定通道的token列表，包含离线用户
	 * </p>
	 * 
	 * @param channel
	 * @return
	 */
	List<Tokens> getAllTokenByChannel(String channel);
	
	/**
	 * <p>
	 * 返回指定通道的token列表，包含离线用户
	 * 主要用于webSocket控制器端群发，需要特别指定domain
	 * </p>
	 * 
	 * @param domain 子域
	 * @param channel
	 * @return
	 */
	List<Tokens> getAllTokenByChannel(String domain, String channel);

	////////////////////////////////////////////////////////////////////////////////
	
	/**
	 * <p>
	 * 上线
	 * </p>
	 * 
	 * @param token
	 * @param sid
	 */
	void online(Tokens token, String sid);
	
	/**
	 * <p>
	 * 离线
	 * </p>
	 * 
	 * @param token
	 * @param sid
	 */
	void offline(Tokens token);
	
	/**
	 * <p>
	 * 离线
	 * </p>
	 * 
	 * @param tokenId
	 * @param sid
	 */
	void offline(String tokenId);

	////////////////////////////////////////////////////////////////////////////////
	
	/**
	 * <p>
	 * 创建新Token（默认通道）
	 * </p>
	 * 
	 * @return
	 */
	Tokens createToken();
	
	/**
	 * <p>
	 * 创建新Token
	 * </p>
	 * 
	 * @param channel 通道代码
	 * @return
	 */
	Tokens createToken(String channel);

}