package itez.plat.socket;

import itez.core.wrapper.dbo.DbProp;
import itez.core.wrapper.dbo.generator.EGenerator;

/**
 * 代码生成器
 * 使用之前需先配置好 DataBaseConfig 数据库连接参数
 * 
 * 	[ 使用方式：文件上鼠标右键 > Run As > Java Application ]
 * 
 * 模型（Model）代码：<Module>.model
 * 业务（Service）代码：<Module>.service
 * 
 * @author netwild
 *
 */
public class Generator extends EGenerator {

	public static void main(String[] args) {
		
		DbProp prop = new DataBaseConfig().getConfig(); //数据库配置文件
		String modulePkgName = Generator.class.getPackage().getName(); //模块包根目录
		String[] tablePrefixes = { ModuleConfig.MODULE_CODE + "_" }; //表名前缀，有多个前缀时中间用逗号隔开
		
		Generator gen = new Generator();
		gen.generator(prop, modulePkgName, tablePrefixes);
	}
	
}
