package itez.plat.socket;

import itez.core.wrapper.dbo.DbProp;
import itez.core.wrapper.dbo.model.IDataBaseConfig;

/**
 * 获取模块的数据库连接参数
 * 
 * @author netwild
 *
 */
public class DataBaseConfig implements IDataBaseConfig {

	@Override
	public DbProp getConfig() {
		
		/**
		 * 直接使用主数据库
		 * 当与其他模块共用数据库时，需要调用 prop.setReName() 方法重新定义连接名称
		 */
		DbProp prop = new itez.plat.main.DataBaseConfig().getConfig();
		prop.setReName(ModuleConfig.MODULE_CODE);
		
		/**
		 * 使用模块独立的数据库
		 * 请先在模块的 [src/main/resources] 目录下创建好 [xxx.properties] 配置文件
		 * 具体格式参考 [web] 项目中的 [main.properties]
		 */
		//DbProp prop = new DbProp(PropKit.use("demo.properties"));
		
		return prop;
	}

}
