package itez.plat.site.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.core.runtime.service.Define;
import itez.plat.site.model.Tags;
import itez.plat.site.service.TagsService;

import java.util.List;

import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class TagsServiceImpl extends EModelService<Tags> implements TagsService {

	@Override
	public boolean existCode(String code, boolean pub) {
		Tags tag;
		if(pub){
			Querys qs = Querys.and(Query.eq("code", code));
			tag = selectFirst(qs, null, false);
		}else{
			Querys qs = Querys.or();
			qs.add(Querys.and(Query.eq("pub", 0)).add(Query.eq("domain", $domain())).add(Query.eq("code", code)));
			qs.add(Querys.and(Query.eq("pub", 1)).add(Query.eq("code", code)));
			tag = selectFirst(qs, null, false);
		}
		return tag != null;
	}
	
	@Override
	public boolean existCode(String code, String id) {
		Querys qs = Querys.and(Query.eq("code", code)).add(Query.ne("id", id));
		Tags tag = selectFirst(qs, null, false);
		return tag != null;
	}
	
	@Override
	public Tags findByCodeAll(String code) {
		Querys qs = Querys.and(Query.eq("code", code));
		Tags tag = selectFirst(qs, null, false);
		return tag;
	}
	
	@Override
	public List<Tags> getTagsEnable() {
		Querys qs = Querys.or();
		qs.add(Querys.and(Query.eq("pub", 0)).add(Query.eq("domain", $domain())));
		qs.add(Query.eq("pub", 1));
		List<Tags> tags = select(qs, null, null, false);
		return tags;
	}

	@Override
	public List<Tags> getTags(String domain) {
		Querys qs = Querys.and(Query.eq("pub", 0)).add(Query.eq("domain", $domain()));
		List<Tags> tags = select(qs, null, null, false);
		return tags;
	}

}