package itez.plat.site.service.impl;

import java.io.File;
import java.util.List;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.inject.Singleton;
import com.jfinal.kit.PathKit;

import itez.core.runtime.modules.ModuleBase;
import itez.core.runtime.modules.ModuleManager;
import itez.core.runtime.service.Define;
import itez.core.runtime.service.EService;
import itez.kit.EDate;
import itez.kit.EFile;
import itez.kit.EProp;
import itez.kit.EStr;
import itez.kit.fileup.EFileFactory;
import itez.plat.site.ModuleConfig;
import itez.plat.site.bean.SiteTemp;
import itez.plat.site.service.SiteTempService;

@Define
@Singleton
public class SiteTempServiceImpl extends EService implements SiteTempService {

	public String getRootPath(){
		return getRootPath($domain());
	}
	
	public String getRootPath(String domain){
		String siteTempRoot = EStr.ifEmpty(EProp.getProp().get("SiteTempRoot"), PathKit.getWebRootPath() + "/siteTemp");
		String path = siteTempRoot.concat(File.separator).concat(domain);
		return path;
	}
	
	public boolean checkTemp(String view){
		String path = getRootPath().concat(File.separator).concat(view);
		File temp = new File(path);
		return temp.exists();
	}
	
	public List<SiteTemp> getTemps(){
		String root = getRootPath();
		List<SiteTemp> temps = Lists.newArrayList();
		File dir = new File(root);
		if(!dir.exists()) return temps;
		if(dir.isFile()) return temps;
		File[] list = dir.listFiles();
		if(list == null || list.length == 0) return temps;
		for(File file : list){
			if(file.isDirectory()) continue;
			SiteTemp temp = new SiteTemp();
			temp.setFileName(file.getName());
			temp.setFilePath(file.getAbsolutePath());
			temp.setContent("");
			temp.setSpace(file.length());
			temps.add(temp);
		}
		return temps;
	}

	public void init(){
		String[] tempList = { "index.html", "channel.html", "content.html" };
		String defPath = EFileFactory.me.getLocalTempPath();
		defPath = defPath.concat("siteTemp");
		File defDir = new File(defPath);
		if(!defDir.exists()){
			try {
				defDir.mkdirs();
				ModuleBase module = ModuleManager.me.getModule(ModuleConfig.MODULE_CODE);
				String resTemp = module.getModuleView() + "/asset/temp";
				for(String temp : tempList){
					String code = EFile.readInRes(resTemp.concat(File.separator).concat(temp));
					if(code != null){
						File file = new File(defPath.concat(File.separator).concat(temp));
						file.createNewFile();
						EFile.write(file, code);
					}
				}
			} catch (Exception e) {
				if(EProp.DevMode) e.printStackTrace();
				throw new RuntimeException(e.getMessage());
			}
		}
		String destPath = getRootPath();
		File destDir = new File(destPath);
		try {
			if(!destDir.exists()) destDir.mkdirs();
			for(String temp : tempList){
				String objPath = destPath.concat(File.separator).concat(temp);
				File src = new File(defPath.concat(File.separator).concat(temp));
				File obj = new File(objPath);
				if(obj.exists()){
					Files.copy(obj, new File(objPath.concat(".").concat(EDate.format(EDate.getDate(), "yyyyMMddHHmmss"))));
				}
				Files.copy(src, obj);
			}
		} catch (Exception e) {
			if(EProp.DevMode) e.printStackTrace();
			throw new RuntimeException(e.getMessage());
		}
	}
	
	public boolean del(String fileName){
		String destPath = getRootPath().concat(File.separator).concat(fileName);
		File file = new File(destPath);
		return file.delete();
	}
	
	public void saveas(String fromName, String toName){
		String fromPath = getRootPath().concat(File.separator).concat(fromName);
		File fromFile = new File(fromPath);
		String toPath = getRootPath().concat(File.separator).concat(toName);
		File toFile = new File(toPath);
		try {
			Files.copy(fromFile, toFile);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public SiteTemp getTemp(String fileName){
		String destPath = getRootPath().concat(File.separator).concat(fileName);
		File file = new File(destPath);
		SiteTemp temp = new SiteTemp();
		temp.setFileName(fileName);
		temp.setFilePath(file.getAbsolutePath());
		temp.setSpace(file.length());
		temp.setContent(EFile.read(file));
		return temp;
	}
	
	public void create(SiteTemp temp){
		String destPath = getRootPath().concat(File.separator).concat(temp.getFileName());
		File file = new File(destPath);
		if(file.exists()) return;
		try {
			file.createNewFile();
			EFile.write(file, temp.getContent());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void modify(SiteTemp temp){
		String destPath = getRootPath().concat(File.separator).concat(temp.getFileName());
		File file = new File(destPath);
		if(!file.exists()) return;
		try {
			EFile.write(file, temp.getContent());
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
