package itez.plat.site.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EFile;
import itez.core.runtime.EContext;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.modules.ModuleManager;
import itez.core.runtime.service.Define;
import itez.plat.site.ModuleConfig;
import itez.plat.site.bean.SiteTempEngine;
import itez.plat.site.model.Info;
import itez.plat.site.service.InfoService;

import java.util.List;

import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class InfoServiceImpl extends EModelService<Info> implements InfoService {

	@Override
	@Cache.able(cache="SITE_BY_DOMAIN")
	public Info getInfo() {
		Info info = selectFirst();
		if(info == null) info = getInfoSync();
		return info;
	}

	@Override
	public Info getInfo(String domain) {
		Querys qs = Querys.and(Query.eq("domain", domain));
		return selectFirst(qs, null, false);
	}
	
	private synchronized Info getInfoSync(){
		Info info = selectFirst();
		if(info == null) info = createInfo();
		return info;
	}
	
	private Info createInfo(){
		Info info = new Info();
		info.setIndex(EContext.getAttr().getSrc() + ModuleManager.me.getModule(ModuleConfig.MODULE_CODE).getModulePath());
		info.setCaption(EContext.getAttr().getComp().getCaption()).setSubCaption("");
		info.setWelcome("欢迎访问网站首页！");
		super.save(info);
		return info;
	}

	@Override
	public List<Info> getInfos() {
		return selectAll();
	}

	@Override
	@Cache.delAll(cache="SITE_BY_DOMAIN")
	public Info modifyInfo(Info info){
		super.update(info);
		return info;
	}
	
	@Override
	public void clearStaticPages() {
		String dirPath = SiteTempEngine.getStaticRootPath();
		EFile.deleteDir(dirPath);
	}

}