package itez.plat.site.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.runtime.service.common.ISiteDomain;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;
import itez.plat.site.model.Domain;
import itez.plat.site.service.DomainService;

import java.util.List;

import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class DomainServiceImpl extends EModelService<Domain> implements DomainService, ISiteDomain {

	@Override
	@Cache.able(key="domain")
	public String getBind(String domain) {
		Querys qs = Querys.and(Query.eq("topDomain", domain));
		Domain item = selectFirst(qs);
		return item == null ? null : item.getSysDomain();
	}

	@Override
	public List<Domain> getBinds() {
		Querys qs = Querys.and(Query.eq("sysDomain", $domain()));
		return select(qs);
	}

	@Override
	@Cache.put(key="domain")
	public Domain setBind(String domain) {
		Domain item = new Domain();
		item.setSysDomain($domain());
		item.setTopDomain(domain);
		save(item);
		return item;
	}

	@Override
	@Cache.del(key="domain")
	public void removeBind(String domain) {
		Querys qs = Querys.and(Query.eq("topDomain", domain));
		Domain item = selectFirst(qs);
		if(item != null) item.delete();
	}

}