package itez.plat.site.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.core.wrapper.dbo.model.Selector;
import itez.kit.EDate;
import itez.kit.EHttp;
import itez.kit.EStr;
import itez.kit.EUid;
import itez.kit.restful.EMap;
import itez.core.runtime.EContext;
import itez.core.runtime.service.Define;
import itez.plat.site.bean.SiteTempEngine;
import itez.plat.site.bean.SiteTempEngine.Type;
import itez.plat.site.model.Channel;
import itez.plat.site.model.Content;
import itez.plat.site.model.Info;
import itez.plat.site.service.ChannelService;
import itez.plat.site.service.ContentService;
import itez.plat.site.service.InfoService;

import java.io.File;
import java.util.Date;
import java.util.List;

import com.beust.jcommander.internal.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jfinal.kit.Kv;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.SqlPara;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class ContentServiceImpl extends EModelService<Content> implements ContentService {

	@Inject
	InfoService infoSer;
	
	@Inject
	ChannelService channelSer;
	
	@Override
	public List<Content> getByChannelId(String channelId){
		return getByChannelId(channelId, null);
	}

	@Override
	public List<Content> getByChannelId(String channelId, Integer limit){
		return getByChannelId(channelId, limit, true);
	}

	@Override
	public List<Content> getByChannelId(String channelId, Integer limit, Boolean desc){
		Querys qs = Querys.and(Query.in("channelId", EStr.ids2sqlIn(channelId)));
		qs.add(Query.eq("draft", false));
		qs.add(Querys.or(Query.nu("validFrom")).add(Query.le("validFrom", EDate.getDate())));
		qs.add(Querys.or(Query.nu("validEnd")).add(Query.ge("validEnd", EDate.getDate())));
		return select(qs, getOrderBy(desc), limit);
	}

	@Override
	public Page<Content> getPageByChannelId(String channelId, Integer pageNum, Integer pageSize, Boolean desc){
		return getPageByChannelId(channelId, pageNum, pageSize, desc, false);
	}

	@Override
	public Page<Content> getPageByChannelId(String channelId, Integer pageNum, Integer pageSize, Boolean desc, Boolean ignoreValid){
		if(null == ignoreValid) ignoreValid = false;
		Querys qs = Querys.and(Query.in("channelId", EStr.ids2sqlIn(channelId)));
		qs.add(Query.eq("draft", false));
		if(!ignoreValid){
			qs.add(Querys.or(Query.nu("validFrom")).add(Query.le("validFrom", EDate.getDate())));
			qs.add(Querys.or(Query.nu("validEnd")).add(Query.ge("validEnd", EDate.getDate())));
		}
		Selector selector = Selector.select().where(qs).orderBy(getOrderBy(desc));
		return paginate(pageNum, pageSize, selector);
	}

	@Override
	public List<Content> searchByChannelId(String channelId, String keyword, Boolean desc){
		Querys qs = Querys.and(Query.in("channelId", EStr.ids2sqlIn(channelId)));
		qs.add(Query.eq("draft", false));
		qs.add(Querys.or(Query.nu("validFrom")).add(Query.le("validFrom", EDate.getDate())));
		qs.add(Querys.or(Query.nu("validEnd")).add(Query.ge("validEnd", EDate.getDate())));
		qs.add(Query.like("caption", "%" + keyword + "%"));
		return select(qs, getOrderBy(desc));
	}

	@Override
	public Page<Content> searchPageByChannelId(String channelId, String keyword, Boolean desc, Integer pageNum, Integer pageSize){
		Querys qs = Querys.and(Query.in("channelId", EStr.ids2sqlIn(channelId)));
		qs.add(Query.eq("draft", false));
		qs.add(Querys.or(Query.nu("validFrom")).add(Query.le("validFrom", EDate.getDate())));
		qs.add(Querys.or(Query.nu("validEnd")).add(Query.ge("validEnd", EDate.getDate())));
		qs.add(Query.like("caption", "%" + keyword + "%"));
		Selector selector = Selector.select().where(qs).orderBy(getOrderBy(desc));
		return paginate(pageNum, pageSize, selector);
	}

	@Override
	public Content first(String channelId){
		Querys qs = Querys.and(Query.eq("channelId", channelId));
		qs.add(Query.eq("draft", false));
		qs.add(Querys.or(Query.nu("validFrom")).add(Query.le("validFrom", EDate.getDate())));
		qs.add(Querys.or(Query.nu("validEnd")).add(Query.ge("validEnd", EDate.getDate())));
		return selectFirst(qs, getOrderBy(false));
	}

	@Override
	public Content last(String channelId){
		Querys qs = Querys.and(Query.eq("channelId", channelId));
		qs.add(Query.eq("draft", false));
		qs.add(Querys.or(Query.nu("validFrom")).add(Query.le("validFrom", EDate.getDate())));
		qs.add(Querys.or(Query.nu("validEnd")).add(Query.ge("validEnd", EDate.getDate())));
		return selectFirst(qs, getOrderBy(true));
	}

	@Override
	public Content next(String channelId, Integer sort, Date cdate){
		Querys qs = Querys.and(Query.eq("channelId", channelId));
		qs.add(Query.eq("draft", false));
		qs.add(Querys.or(Query.nu("validFrom")).add(Query.le("validFrom", EDate.getDate())));
		qs.add(Querys.or(Query.nu("validEnd")).add(Query.ge("validEnd", EDate.getDate())));
		qs.add(Querys.or(Query.lt("sort", sort)).add(Query.lt("cdate", cdate)));
		return selectFirst(qs, getOrderBy(true));
	}

	@Override
	public Content previous(String channelId, Integer sort, Date cdate){
		Querys qs = Querys.and(Query.eq("channelId", channelId));
		qs.add(Query.eq("draft", false));
		qs.add(Querys.or(Query.nu("validFrom")).add(Query.le("validFrom", EDate.getDate())));
		qs.add(Querys.or(Query.nu("validEnd")).add(Query.ge("validEnd", EDate.getDate())));
		qs.add(Querys.or(Query.gt("sort", sort)).add(Query.gt("cdate", cdate)));
		return selectFirst(qs, getOrderBy(false));
	}
	
	@Override
	public List<Content> queryByTag(String codes, String keyword, Integer limit, Boolean desc, Boolean domainSelf) {
		String[] codeArr = codes.split(",");
		Querys findQs = Querys.or();
		for(String code : codeArr) findQs.add(Query.fin("tagCodes", code));
		Querys qs = Querys.and(findQs).add(Query.eq("draft", false));
		qs.add(Querys.or(Query.nu("validFrom")).add(Query.le("validFrom", EDate.getDate())));
		qs.add(Querys.or(Query.nu("validEnd")).add(Query.ge("validEnd", EDate.getDate())));
		if(EStr.notEmpty(keyword)) qs.add(Query.like("caption", "%" + keyword + "%"));
		return select(qs, getOrderBy(desc), limit, domainSelf);
	}
	
	@Override
	public Page<Content> queryPageByTag(String codes, Integer pageNum, Integer pageSize, Boolean desc, Boolean domainSelf) {
		String[] codeArr = codes.split(",");
		Querys findQs = Querys.or();
		for(String code : codeArr) findQs.add(Query.fin("tagCodes", code));
		Querys qs = Querys.and(findQs).add(Query.eq("draft", false));
		qs.add(Querys.or(Query.nu("validFrom")).add(Query.le("validFrom", EDate.getDate())));
		qs.add(Querys.or(Query.nu("validEnd")).add(Query.ge("validEnd", EDate.getDate())));
		Selector selector = Selector.select().where(qs).orderBy(getOrderBy(desc));
		return paginate(pageNum, pageSize, selector, domainSelf);
	}
	
	/**
	 * <p>
	 * 返回排序字段
	 * </p>
	 * 
	 * @param desc true：倒叙，false：正序
	 * @return
	 */
	private String getOrderBy(Boolean desc){
		if(desc == null) desc = false;
		String dir = desc ? " desc" : "";
		StringBuilder ord = new StringBuilder();
		ord.append("isTop" + dir);
		ord.append(", sort" + dir);
		ord.append(", cdate" + dir);
		return ord.toString();
	}

	@Override
	public void removeByChannels(String channelIds) {
		String sql = String.format("delete from site_content where channelId in (%s)", EStr.ids2sqlIn(channelIds));
		dbo().delete(sql);
	}

	@Override
	public List<Record> getBetweenYears(String domain, Integer yearf, Integer yeare) {
		Kv params = Kv.by("domain", domain).set("yearFrom", yearf).set("yearEnd", yeare);
		SqlPara sql = dbo().getSqlPara("site.Get_Content_Between_Years", params);
		return dbo().find(sql);
	}

	@Override
	public void removeBetweenYears(String domain, Integer yearf, Integer yeare){
		Kv params = Kv.by("domain", domain).set("yearFrom", yearf).set("yearEnd", yeare);
		SqlPara sql = dbo().getSqlPara("site.Remove_Content_Between_Years", params);
		dbo().update(sql);
	}
	
	@Override
	public void removeStaticPage(String ids) {
		Info info = infoSer.getInfo();
		if(info.getGenMode() == 0) return; //动态页面直接跳出
		String root = SiteTempEngine.getWebRoot();
		List<Content> cnts = findByIds(ids);
		Channel chn = channelSer.findById(cnts.get(0).getChannelId());
		for(Content cnt : cnts){
			String path = SiteTempEngine.formatStaticPath(Type.CONTENT, chn, cnt);
			File file = new File(root + path);
			if(file.exists()) file.delete();
		}
	}
	
	@Override
	public void genStaticPage(String ids) {
		Info info = infoSer.getInfo();
		if(info.getGenMode() == 0) return; //动态页面直接跳出
		List<Content> cnts = findByIds(ids);
		String url;
		for(Content cnt : cnts){
			url = cnt.domainUrl();
			if(!url.startsWith("http")) url = EStr.join(EContext.getAttr().getScheme(), ":", url);
			EHttp.me.get(EStr.join(url, "?_GEN_MODE_=true"));
		}
	}
	
	@Override
	public List<Content> getTops(String pid) {
		Querys qs = Querys.and(Query.eq("channelId", pid)).add(Query.eq("isTop", true));
		qs.add(Query.eq("draft", false));
		qs.add(Querys.or(Query.nu("validFrom")).add(Query.le("validFrom", EDate.getDate())));
		qs.add(Querys.or(Query.nu("validEnd")).add(Query.ge("validEnd", EDate.getDate())));
		return select(qs, getOrderBy(true));
	}

	@Override
	public void conbt(Content content, String[] conbtTo) {
		List<Channel> chns = channelSer.findByIda(conbtTo);
		List<Content> conts = Lists.newArrayList();
		chns.forEach(chn -> {
			Content cont = new Content();
			cont._setAttrs(content);
			cont.setId(EUid.generator()).setDomain(chn.getDomain());
			cont.setChannelId(chn.getId()).setChannelCaption(chn.getCaption());
			cont.setDraft(chn.getConbtDraft()).setSrcId(content.getId());
			conts.add(cont);
		});
		dbo().batchSave(conts, conts.size());
	}

	@Override
	public List<Record> getDraft() {
		Kv params = Kv.by("domain", $domain());
		SqlPara sql = dbo().getSqlPara("site.GetDraft", params);
		return dbo().find(sql);
	}

	@Override
	public Page<Record> supSearchPage(EMap map, Integer page, Integer pageSize) {
		SqlPara sql = dbo().getSqlPara("site.SupSearch", map);
		Page<Record> list = dbo().paginate(page, pageSize, sql);
		return list;
	}

	@Override
	public List<Record> supSearch(EMap map) {
		SqlPara sql = dbo().getSqlPara("site.SupSearch", map);
		List<Record> list = dbo().find(sql);
		return list;
	}

	@Override
	public List<Content> getSameContent(String caption) {
		Querys qs = Querys.and(Query.eq("caption", caption));
		return select(qs, null, 3, "id", "channelCaption", "caption", "author", "cdate", "draft");
	}

}