package itez.plat.site.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EStr;
import itez.core.runtime.service.Define;
import itez.plat.site.model.CollectorSrc;
import itez.plat.site.service.CollectorSrcService;

import java.util.List;

import com.google.inject.Singleton;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class CollectorSrcServiceImpl extends EModelService<CollectorSrc> implements CollectorSrcService {
	
	@Override
	public List<CollectorSrc> getSrcList() {
		if(!$user().checkSupAdmin()) return selectAll();
		Querys qs = Querys.or(Query.eq("domain", CollectorCommon.PUBLIC_DOMAIN)).add(Query.eq("domain", $domain()));
		return select(qs, null, null, false);
	}
	
	@Override
	public List<CollectorSrc> getSrcList(String type) {
		String domain = $domain();
		Querys qs = Querys.and();
		if(EStr.notEmpty(type)) qs.add(Query.eq("type", type));
		qs.add(Querys.or(Query.eq("domain", CollectorCommon.PUBLIC_DOMAIN)).add(Query.eq("domain", domain)));
		return select(qs, null, null, false);
	}
	
	@Override
	public void addSrc(CollectorSrc src) {
		if(EStr.isEmpty(src.getDomain())) src.setDomain(CollectorCommon.PUBLIC_DOMAIN);
		saveOrUpdate(src);
	}

}