package itez.plat.site.service.impl;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.core.wrapper.dbo.model.Selector;
import itez.kit.EStr;
import itez.kit.restful.EMap;
import itez.core.runtime.service.Define;
import itez.plat.site.model.CollectorItem;
import itez.plat.site.service.CollectorItemService;
import java.util.List;
import com.google.inject.Singleton;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.SqlPara;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class CollectorItemServiceImpl extends EModelService<CollectorItem> implements CollectorItemService {
	
	@Override
	public List<CollectorItem> getItems(String tasklId) {
		return getItems(tasklId, null);
	}

	@Override
	public List<CollectorItem> getItems(String tasklId, Boolean state) {
		Querys qs = Querys.and(Query.eq("taskId", tasklId));
		if(null != state) qs.add(Query.eq("state", state));
		return select(qs);
	}
	
	@Override
	public Page<CollectorItem> getItemPage(String tasklId, int pageNumber, int pageSize) {
		Querys qs = Querys.and(Query.eq("taskId", tasklId));
		return paginate(pageNumber, pageSize, Selector.select().where(qs));
	}
	
	@Override
	public String getItemsHash(String taskId) {
		EMap paras = EMap.by("taskId", taskId);
		SqlPara sql = dbo().getSqlPara("site.GetCollectorHash", paras);
		Record rec = dbo().findFirst(sql);
		return rec == null ? "" : EStr.ifEmpty(rec.getStr("hashs"), "");
	}

}