package itez.plat.site.service.impl;

import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.core.wrapper.dbo.model.Selector;
import itez.kit.EHttp;
import itez.kit.EStr;
import itez.kit.restful.EMap;
import itez.core.runtime.EContext;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;
import itez.core.runtime.service.ETreeService;
import itez.core.util.ECacheKit;
import itez.plat.site.ModuleConfig;
import itez.plat.site.bean.SiteTempEngine;
import itez.plat.site.bean.SiteTempEngine.Type;
import itez.plat.site.model.Channel;
import itez.plat.site.model.Info;
import itez.plat.site.service.ChannelService;
import itez.plat.site.service.ContentService;
import itez.plat.site.service.InfoService;
import itez.plat.site.service.NaviItemService;

import java.io.File;
import java.util.List;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jfinal.kit.Kv;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.SqlPara;

/**
 * 由JWinner Service Generator自动生成。
 */
@Define
@Singleton
public class ChannelServiceImpl extends ETreeService<Channel> implements ChannelService {

	@Inject
	InfoService infoSer;
	
	@Inject
	ContentService contentSer;
	
	@Inject
	NaviItemService naviItemSer;

	@Override
	@Cache.able(cache="SITE_CHANNEL", key="code")
	public Channel findByCode(String code) {
		Querys qs = Querys.and(Query.eq("code", code));
		return selectFirst(qs);
	}

	@Override
	@Cache.able(cache="SITE_CHANNEL", key="'Index'")
	public Channel getIndexChannel() {
		Querys qs = Querys.and(Query.eq("code", ModuleConfig.INDEX_CODE));
		Channel channel = selectFirst(qs);
		if(channel == null) channel = getIndexChannelSync();
		return channel;
	}
	
	private synchronized Channel getIndexChannelSync(){
		Querys qs = Querys.and(Query.eq("code", ModuleConfig.INDEX_CODE));
		Channel channel = selectFirst(qs);
		if(channel == null) channel = createIndexChannel();
		return channel;
	}

	private Channel createIndexChannel() {
		Channel channel = new Channel();
		channel.setCode(ModuleConfig.INDEX_CODE);
		channel.setIcon("fa fa-home");
		channel.setPic("");
		channel.setCaption("网站首页");
		channel.setContent("");
		channel.setPath("001");
		channel.setSort(1);
		channel.setChannelTemp("index.html");
		channel.setContentTemp("content.html");
		super.save(channel);
		return channel;
	}

	@Override
	public List<Channel> getAllChannels() {
		return select(null, "path");
	}

	@Override
	public List<Record> getBackChannels(String domain) {
		Kv paras = Kv.by("domain", domain);
		SqlPara sql = dbo().getSqlPara("site.Backup_Channel", paras);
		return dbo().find(sql);
	}

	@Override
	@Cache.delAll(cache="SITE_CHANNEL")
	public void removeAllChannels(String domain) {
		Kv paras = Kv.by("domain", domain);
		SqlPara sql = dbo().getSqlPara("site.Restore_Channel", paras);
		dbo().update(sql);
	}

	@Override
	public List<Channel> getTreeChannels() {
		Querys qs = Querys.and(Query.nn("pid"));
		Selector selector = Selector.select("id, pid, code, icon, pic, caption, subCaption, path").where(qs).orderBy("path");
		return select(selector);
	}

	@Override
	public void addChannel(Channel channel){
		super.save(channel);
	}

	@Override
	@Cache.del(cache="SITE_CHANNEL", key="channel.code")
	public void modifyChannel(Channel channel){
		super.update(channel);
	}

	@Override
	@Cache.delAll(cache="SITE_CHANNEL")
	public void removeChannels(String ids){
		String[] idsArr = ids.split(",");
		List<String> subIds = Lists.newArrayList();
		for(String id : idsArr){
			subIds.addAll(getChildrenIds(id));
		}
		subIds.add(ids);
		String idAndSubs = EStr.parseArray(subIds);
		contentSer.removeByChannels(idAndSubs);
		naviItemSer.removeByChannels(idAndSubs);
		super.deleteByIds(idAndSubs);
	}
	
	@Override
	public void genChannelPath() {
		genChannelPath($domain());
	}
	
	@Override
	public void genChannelPath(String domain) {
		List<Record> chns = getBackChannels(domain);
		if(chns.size() == 0) return;
		EMap chnTree = EMap.create();	//栏目树型关系（pid -> ind1, ind2, ind3...
		int rootInd = 0;				//根节点ind
		for(int i = 0, len = chns.size(); i < len; i++){
			Record chn = chns.get(i);
			String pid = chn.getStr("pid");
			if(EStr.isEmpty(pid)){		//根节点
				rootInd = i;
			}else if(chnTree.containsKey(pid)){
				String ids = chnTree.getStr(pid);
				chnTree.set(pid, ids + "," + i);
			}else{
				chnTree.set(pid, i);
			}
		}
		genChannelPathEvent(chns, chnTree, rootInd);
		chns.get(0).set("sort", chns.get(0).get("sort")).set("path", chns.get(0).get("path"));
		dbo().batchUpdate("site_channel", chns, chns.size());
		ECacheKit.removeAllBase(ECacheKit.appendTenant(domain, "SITE_CHANNEL"));
	}
	
	/**
	 * <p>
	 * 设置指定栏目的子栏目路径（递归）
	 * </p>
	 * 
	 * @param chns 栏目列表
	 * @param chnTree 栏目树型关系
	 * @param pind 父节点索引
	 */
	private void genChannelPathEvent(List<Record> chns, EMap chnTree, int pind){
		Record chn = chns.get(pind);
		String pid = chn.getStr("id");
		String path = chn.getStr("path");
		if(!chnTree.containsKey(pid)) return;
		String[] indArr = chnTree.getStr(pid).split(",");
		for(int i = 1, len = indArr.length; i <= len; i++){
			Integer ind = Integer.parseInt(indArr[i-1]);
			Record sub = chns.get(ind);
			sub.set("sort", i);
			sub.set("path", EStr.join(path, "_", EStr.addPrefix(i, 3)));
			genChannelPathEvent(chns, chnTree, ind);
		}
	}

	@Override
	public Channel getLastChannel(String pid) {
		Querys qs = Querys.and();
		return super.getLast(qs, pid);
	}

	@Override
	public void sort(String pid, String opt, String ids) {
		super.sort(null, pid, SORT_DIR.valueOf(opt), ids);
	}
	
	@Override
	public List<Channel> getLocation(String path) {
		EMap paras = EMap.by("domain", $domain()).set("path", path);
		SqlPara sql = dbo().getSqlPara("site.ChannelLocation", paras);
		List<Record> recs = dbo().find(sql);
		return parseModel(recs, Channel.class);
	}

	@Override
	public List<Channel> getChildren(String id){
		Querys qs = Querys.and(Query.eq("pid", id));
		return select(qs, "sort");
	}

	@Override
	public List<String> getChildrenIds(String id) {
		Channel parent = findById(id);
		Querys qs = Querys.and(Query.like("path", parent.getPath() + "%"));
		return selectCol(qs, "id");
	}
	
	@Override
	public void removeStaticPage(String ids) {
		Info info = infoSer.getInfo();
		if(info.getGenMode() == 0) return; //动态页面直接跳出
		String root = SiteTempEngine.getWebRoot();
		if(EStr.isEmpty(ids)){ //首页
			String path = SiteTempEngine.formatStaticPath(Type.INDEX, null, null);
			File file = new File(root + path);
			if(file.exists()) file.delete();
		}else{ //栏目页
			List<Channel> chns = findByIds(ids);
			for(Channel chn : chns){
				String path = SiteTempEngine.formatStaticPath(Type.CHANNEL, chn, null);
				File file = new File(root + path);
				if(file.exists()) file.delete();
			}
		}
	}
	
	@Override
	public void genStaticPage(String ids) {
		genStaticPage(ids, 0);
	}
	
	@Override
	public void genStaticPage(String ids, Integer pageSize) {
		Info info = infoSer.getInfo();
		if(info.getGenMode() == 0) return; //动态页面直接跳出
		String url;
		List<Channel> chns = findByIds(ids);
		for(Channel chn : chns){
			url = chn.domainUrl(1);
			if(!url.startsWith("http")) url = EStr.join(EContext.getAttr().getScheme(), ":", url);
			if(pageSize == 0){
				EHttp.me.get(EStr.join(url, "?_GEN_MODE_=true"));
			}else{
				Integer contentSize = getContentSize(chn.getId());
				Integer pageCount = (int)Math.ceil(contentSize * 1.0 / pageSize);
				for(int i = 1; i <= pageCount; i++){
					EHttp.me.get(EStr.join(url, "?_GEN_MODE_=true&page=", i));
				}
			}
		}
	}
	
	@Override
	public Integer getContentSize(String id) {
		EMap paras = EMap.by("domain", $domain()).set("channelId", id);
		SqlPara sql = dbo().getSqlPara("site.GetContentSize", paras);
		Record rec = dbo().findFirst(sql);
		return rec.getInt("cnt");
	}

	@Override
	public List<Record> getConbtChannels() {
		EMap paras = EMap.by("domain", $domain());
		SqlPara sql = dbo().getSqlPara("site.GetConbtChannels", paras);
		List<Record> recs = dbo().find(sql);
		return recs;
	}
	
}