package itez.plat.site.service.impl;

import java.io.File;

import itez.core.runtime.service.Ioc;
import itez.kit.EDate;
import itez.kit.EStr;
import itez.kit.fileup.EFileFactory;
import itez.plat.site.ModuleConfig;
import itez.plat.site.service.SiteTempService;

/**
 * <p>
 * 备份路径
 * </p>
 * 
 * <p>Copyright(C) 2017-2021 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2021年10月28日 下午12:58:59
 */

class BakDirs {
	
	private String srcResRoot;
	private String srcTempRoot;
	private String srcFileRoot;
	
	private String bakDirName;
	private String bakRoot;
	private String bakDataRoot;
	private String bakTempRoot;
	private String bakResRoot;
	private String bakFileRoot;
	
	private static SiteTempService tempSer = Ioc.get(SiteTempService.class);
	
	public BakDirs(String domain){
		init(domain, null);
	}
		
	public BakDirs(String domain, String bakDirName){
		init(domain, bakDirName);
	}
	
	private void init(String domain, String bakDirName){
		if(EStr.isEmpty(bakDirName)) bakDirName = EStr.join(domain, "_", EDate.format(EDate.getDate(), "yyyyMMdd_HHmmssSSS"));
		this.bakDirName = bakDirName;
		String localPath = EFileFactory.me.getLocalDiskPath();
		srcResRoot = EStr.join(localPath, domain, EStr.FileSep, "res");
		srcFileRoot = EStr.join(localPath, domain, EStr.FileSep, ModuleConfig.MODULE_CODE);
		srcTempRoot = tempSer.getRootPath(domain);
		bakRoot = EStr.join(localPath, domain, EStr.FileSep, "bak", EStr.FileSep, "site", EStr.FileSep, bakDirName);
		bakDataRoot = EStr.join(bakRoot, EStr.FileSep, "data");
		bakTempRoot = EStr.join(bakRoot, EStr.FileSep, "temp");
		bakResRoot = EStr.join(bakRoot, EStr.FileSep, "res");
		bakFileRoot = EStr.join(bakRoot, EStr.FileSep, "upload");
	}
	
	public void initDirs(){
		File srcResRootPath = new File(srcResRoot);
		if(!srcResRootPath.exists()) srcResRootPath.mkdirs();
		File srcFileRootPath = new File(srcFileRoot);
		if(!srcFileRootPath.exists()) srcFileRootPath.mkdirs();
		File srcTempRootPath = new File(srcTempRoot);
		if(!srcTempRootPath.exists()) srcTempRootPath.mkdirs();
		File bakRootPath = new File(bakRoot);
		if(!bakRootPath.exists()) bakRootPath.mkdirs();
		File bakDataRootPath = new File(bakDataRoot);
		if(!bakDataRootPath.exists()) bakDataRootPath.mkdirs();
		File bakTempRootPath = new File(bakTempRoot);
		if(!bakTempRootPath.exists()) bakTempRootPath.mkdirs();
		File bakResRootPath = new File(bakResRoot);
		if(!bakResRootPath.exists()) bakResRootPath.mkdirs();
		File bakFileRootPath = new File(bakFileRoot);
		if(!bakFileRootPath.exists()) bakFileRootPath.mkdirs();
	}

	public String getSrcResRoot() {
		return srcResRoot;
	}
	public String getSrcTempRoot() {
		return srcTempRoot;
	}
	public String getSrcFileRoot() {
		return srcFileRoot;
	}
	public String getBakDirName() {
		return bakDirName;
	}
	public String getBakRoot() {
		return bakRoot;
	}
	public String getBakDataRoot() {
		return bakDataRoot;
	}
	public String getBakTempRoot() {
		return bakTempRoot;
	}
	public String getBakResRoot() {
		return bakResRoot;
	}
	public String getBakFileRoot() {
		return bakFileRoot;
	}
	
}
