/**
 * BakAble.java
 */
package itez.plat.site.service.impl;

import itez.kit.EStr;
import itez.kit.restful.EMap;
import itez.plat.site.model.Backup;

/**
 * <p>
 * 备份范围
 * </p>
 * 
 * <p>Copyright(C) 2017-2021 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2021年10月28日 下午2:27:49
 */
class BakAble {

	private boolean enData;
	
	private boolean enInfo;
	private boolean enChannel;
	private boolean enContent;
	private boolean enTag;
	private boolean enNav;
	
	private boolean enChannelRep;
	private boolean enContentRep;
	private boolean enTagRep;
	private boolean enNavRep;
	
	private boolean enTemp;
	private boolean enRes;
	private boolean enUpload;
	
	public BakAble(Backup bak){
		String dataScope = bak.getDataScope();
		String fileScope = bak.getFileScope();
		init(dataScope, fileScope);
	}
	
	public BakAble(EMap paras){
		String dataScope = paras.getStr("dataScope");
		String fileScope = paras.getStr("fileScope");
		init(dataScope, fileScope);
		enChannelRep = paras.getStr("chnRep").equals("true");
		enContentRep = paras.getStr("conRep").equals("true");
		enTagRep = paras.getStr("tagRep").equals("true");
		enNavRep = paras.getStr("navRep").equals("true");
	}
	
	private void init(String dataScope, String fileScope){
		enData = EStr.notEmpty(dataScope);
		if(enData){
			dataScope = EStr.join(",", dataScope, ",");
			enInfo = dataScope.indexOf(",info,") > -1;
			enChannel = dataScope.indexOf(",channel,") > -1;
			enContent = dataScope.indexOf(",content,") > -1;
			enTag = dataScope.indexOf(",tag,") > -1;
			enNav = dataScope.indexOf(",nav,") > -1;
		}
		if(EStr.notEmpty(fileScope)){
			fileScope = EStr.join(",", fileScope, ",");
			enTemp = fileScope.indexOf(",temp,") > -1;
			enRes = fileScope.indexOf(",res,") > -1;
			enUpload = fileScope.indexOf(",upload,") > -1;
		}
	}

	public boolean isEnData() {
		return enData;
	}

	public boolean isEnInfo() {
		return enInfo;
	}

	public boolean isEnChannel() {
		return enChannel;
	}

	public boolean isEnContent() {
		return enContent;
	}

	public boolean isEnTag() {
		return enTag;
	}

	public boolean isEnNav() {
		return enNav;
	}

	public boolean isEnChannelRep() {
		return enChannelRep;
	}

	public boolean isEnContentRep() {
		return enContentRep;
	}

	public boolean isEnTagRep() {
		return enTagRep;
	}

	public boolean isEnNavRep() {
		return enNavRep;
	}

	public boolean isEnTemp() {
		return enTemp;
	}

	public boolean isEnRes() {
		return enRes;
	}

	public boolean isEnUpload() {
		return enUpload;
	}
	
}
