package itez.plat.site.service;

import java.util.List;

import itez.core.runtime.service.IModelService;
import itez.plat.site.model.Tags;

/**
 * 由JWinner Service Generator自动生成。
 */
public interface TagsService extends IModelService<Tags>{

	/**
	 * <p>
	 * 添加标签时的别名重复校验
	 * </p>
	 * 
	 * @param code
	 * @param pub
	 * @return
	 */
	boolean existCode(String code, boolean pub);

	/**
	 * <p>
	 * 将站内标签切换成跨站标签时的别名重复校验
	 * </p>
	 * 
	 * @param code
	 * @param id
	 * @return
	 */
	boolean existCode(String code, String id);
	
	/**
	 * <p>
	 * 跨站获取标签
	 * </p>
	 * 
	 * @param code
	 * @return
	 */
	Tags findByCodeAll(String code);
	
	/**
	 * <p>
	 * 返回当前站点可用的标签（含站内标签及跨站标签）
	 * </p>
	 * 
	 * @return
	 */
	List<Tags> getTagsEnable();
	
	/**
	 * 返回当前站点的标签（用于网站备份）
	 * @param domain
	 * @return
	 */
	List<Tags> getTags(String domain);
	
}