package itez.plat.site.service;

import java.util.Date;
import java.util.List;

import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.Record;

import itez.core.runtime.service.IModelService;
import itez.kit.restful.EMap;
import itez.plat.site.model.Content;

/**
 * 由JWinner Service Generator自动生成。
 */
public interface ContentService extends IModelService<Content>{

	/**
	 * <p>
	 * 返回指定栏目内的全部文章
	 * </p>
	 * 
	 * @param channelId
	 * @return
	 */
	public List<Content> getByChannelId(String channelId);
	
	/**
	 * <p>
	 * 返回栏目内头几篇文章
	 * 注1：按倒叙返回文章列表
	 * 注2：不包含子栏目文章
	 * </p>
	 * 
	 * @param channelId
	 * @param limit
	 * @return
	 */
	public List<Content> getByChannelId(String channelId, Integer limit);
	
	/**
	 * <p>
	 * 返回栏目内头几篇文章
	 * 注1：不包含子栏目文章
	 * </p>
	 * 
	 * @param channelId
	 * @param limit
	 * @param desc
	 * @return
	 */
	public List<Content> getByChannelId(String channelId, Integer limit, Boolean desc);
	
	/**
	 * <p>
	 * 返回栏目内指定页码的文章列表
	 * </p>
	 * 
	 * @param channelId
	 * @param pageNum
	 * @param pageSize
	 * @param desc
	 * @return
	 */
	public Page<Content> getPageByChannelId(String channelId, Integer pageNum, Integer pageSize, Boolean desc);
	
	/**
	 * <p>
	 * 返回栏目内指定页码的文章列表
	 * </p>
	 * 
	 * @param channelId
	 * @param pageNum
	 * @param pageSize
	 * @param desc
	 * @return
	 */
	public Page<Content> getPageByChannelId(String channelId, Integer pageNum, Integer pageSize, Boolean desc, Boolean ignoreValid);
	
	/**
	 * <p>
	 * 搜索栏目内的文章
	 * </p>
	 * 
	 * @param channelId
	 * @param keyword
	 * @param desc
	 * @return
	 */
	public List<Content> searchByChannelId(String channelId, String keyword, Boolean desc);
	
	/**
	 * <p>
	 * 搜索栏目内的文章
	 * </p>
	 * 
	 * @param channelId
	 * @param keyword
	 * @param desc
	 * @param pageNum
	 * @param pageSize
	 * @return
	 */
	public Page<Content> searchPageByChannelId(String channelId, String keyword, Boolean desc, Integer pageNum, Integer pageSize);
	
	/**
	 * <p>
	 * 返回栏目内第一篇文章
	 * </p>
	 * 
	 * @param channelId
	 * @return
	 */
	public Content first(String channelId);
	
	/**
	 * <p>
	 * 返回栏目内最后一篇文章
	 * </p>
	 * 
	 * @param channelId
	 * @return
	 */
	public Content last(String channelId);
	
	/**
	 * <p>
	 * 返回栏目内下一篇文章
	 * </p>
	 * 
	 * @param channelId
	 * @param sort
	 * @param cdate
	 * @return
	 */
	public Content next(String channelId, Integer sort, Date cdate);
	
	/**
	 * <p>
	 * 返回栏目内上一篇文章
	 * </p>
	 * 
	 * @param channelId
	 * @param sort
	 * @param cdate
	 * @return
	 */
	public Content previous(String channelId, Integer sort, Date cdate);
	
	////////////////////////// 按标签查找  /////////////////////////////////////

	/**
	 * <p>
	 * 根据标签返回文章列表（跨站）
	 * </p>
	 * 
	 * @param codes
	 * @param keyword
	 * @param limit
	 * @param desc
	 * @return
	 */
	List<Content> queryByTag(String codes, String keyword, Integer limit, Boolean desc, Boolean domainSelf);
	
	/**
	 * <p>
	 * 根据标签分页返回文章列表（跨站）
	 * </p>
	 * 
	 * @param codes
	 * @param pageNum
	 * @param pageSize
	 * @param desc
	 * @return
	 */
	Page<Content> queryPageByTag(String codes, Integer pageNum, Integer pageSize, Boolean desc, Boolean domainSelf);
	
	////////////////////////// 文章管理  /////////////////////////////////////
	
	/**
	 * <p>
	 * 删除栏目内的全部文章
	 * </p>
	 * 
	 * @param channelIds
	 */
	public void removeByChannels(String channelIds);
	
	/**
	 * <p>
	 * 返回指定年份的文章
	 * </p>
	 * 
	 * @param domain
	 * @param yearf
	 * @param yeare
	 * @return
	 */
	public List<Record> getBetweenYears(String domain, Integer yearf, Integer yeare);
	
	/**
	 * <p>
	 * 删除指定年份的文章
	 * </p>
	 * 
	 * @param domain
	 * @param yearf
	 * @param yeare
	 */
	public void removeBetweenYears(String domain, Integer yearf, Integer yeare);
	
	/**
	 * <p>
	 * 删除指定文章的静态页面
	 * </p>
	 * 
	 * @param ids
	 */
	public void removeStaticPage(String ids);
	
	/**
	 * <p>
	 * 生成指定文章的静态页面
	 * </p>
	 * 
	 * @param ids
	 */
	public void genStaticPage(String ids);
	
	/**
	 * <p>
	 * 返回栏目内的置顶文章
	 * </p>
	 * 
	 * @return
	 */
	List<Content> getTops(String pid);
	
	/**
	 * <p>
	 * 投稿抄送
	 * </p>
	 * 
	 * @param content
	 * @param conbtTo
	 */
	void conbt(Content content, String[] conbtTo);
	
	/**
	 * <p>
	 * 草稿箱文章列表
	 * </p>
	 * 
	 * @return
	 */
	List<Record> getDraft();
	
	/**
	 * <p>
	 * 后台文章搜索
	 * </p>
	 * 
	 * @param map
	 * @return
	 */
	Page<Record> supSearchPage(EMap map, Integer page, Integer pageSize);
	
	/**
	 * <p>
	 * 后台文章搜索
	 * </p>
	 * 
	 * @param map
	 * @return
	 */
	List<Record> supSearch(EMap map);
	
	/**
	 * 检索同名文章
	 * @param caption
	 * @return
	 */
	List<Content> getSameContent(String caption);
	
}