package itez.plat.site.service;

import java.util.List;

import itez.core.runtime.service.IModelService;
import itez.plat.site.model.Channel;
import itez.plat.site.model.CollectorItem;
import itez.plat.site.model.CollectorSrc;
import itez.plat.site.model.CollectorTask;
import itez.plat.site.model.Content;

/**
 * 由JWinner Service Generator自动生成。
 */
public interface CollectorTaskService extends IModelService<CollectorTask>{

	/**
	 * <p>
	 * 返回指定栏目的采集任务列表
	 * </p>
	 * 
	 * @param channelCode
	 * @return
	 */
	List<CollectorTask> getTasks(String channelCode);
	
	/**
	 * <p>
	 * 返回指定栏目、采集源、采集地址的历史任务
	 * </p>
	 * 
	 * @param channelCode
	 * @param srcId
	 * @param url
	 * @return
	 */
	CollectorTask getTask(String channelCode, String srcId, String url);
	
	/**
	 * <p>
	 * 列表采集
	 * </p>
	 * 
	 * @param task 采集任务
	 */
	int collList(CollectorTask task);
	
	/**
	 * <p>
	 * 文章采集
	 * </p>
	 * 
	 * @param task 采集任务
	 * @param repeat 是否对已采集过的文章重复采集
	 * @param odate 是否使用原文发布日期
	 */
	int collItem(CollectorTask task, Boolean repeat, Boolean odate);
	
	/**
	 * <p>
	 * 文章采集（单条）
	 * </p>
	 * 
	 * @param domain 子域（资源保存位置）
	 * @param channel 所在栏目
	 * @param src 采集源
	 * @param origDate 是否保留原日期
	 * @param item 采集目标
	 * @param throwException 是否抛出异常
	 * @return
	 */
	Content collItemDetail(String domain, Channel channel, CollectorSrc src, Boolean origDate, CollectorItem item, boolean throwException);
	
	/**
	 * <p>
	 * 删除采集明细
	 * </p>
	 * 
	 * @param taskId 采集任务ID
	 * @param delContent 是否同时删除文章
	 */
	void delItem(String taskId, Boolean delContent);

}