package itez.plat.site.service;

import java.util.List;

import com.jfinal.plugin.activerecord.Page;

import itez.core.runtime.service.IModelService;
import itez.plat.site.model.CollectorItem;

/**
 * 由JWinner Service Generator自动生成。
 */
public interface CollectorItemService extends IModelService<CollectorItem>{

	/**
	 * <p>
	 * 根据采集任务返回明细列表
	 * </p>
	 * 
	 * @param tasklId
	 * @return
	 */
	List<CollectorItem> getItems(String tasklId);

	/**
	 * <p>
	 * 根据采集任务返回明细列表
	 * </p>
	 * 
	 * @param tasklId
	 * @param state 文章采集状态
	 * @return
	 */
	List<CollectorItem> getItems(String tasklId, Boolean state);
	
	/**
	 * <p>
	 * 根据采集任务返回明细列表分页数据
	 * </p>
	 * 
	 * @param tasklId
	 * @param pageNumber
	 * @param pageSize
	 * @return
	 */
	Page<CollectorItem> getItemPage(String tasklId, int pageNumber, int pageSize);
	
	/**
	 * <p>
	 * 返回指定任务的明细地址Hash串，用于判断该地址是否存在
	 * </p>
	 * 
	 * @param taskId
	 * @return
	 */
	String getItemsHash(String taskId);

}