package itez.plat.site.service;

import java.util.List;

import com.jfinal.plugin.activerecord.Record;

import itez.core.runtime.service.ITreeService;
import itez.plat.site.model.Channel;

/**
 * 由JWinner Service Generator自动生成。
 */
public interface ChannelService extends ITreeService<Channel>{
		
	/**
	 * <p>
	 * 返回首页栏目
	 * </p>
	 * 
	 * @return
	 */
	public Channel getIndexChannel();
	
	/**
	 * <p>
	 * 返回所有栏目
	 * </p>
	 * 
	 * @return
	 */
	public List<Channel> getAllChannels();
	
	/**
	 * <p>
	 * 返回所有栏目（树型结构）
	 * </p>
	 * 
	 * @return
	 */
	public List<Channel> getTreeChannels();
	
	/**
	 * <p>
	 * 添加栏目
	 * </p>
	 * 
	 * @param channel
	 */
	public void addChannel(Channel channel);
	
	/**
	 * <p>
	 * 修改栏目
	 * </p>
	 * 
	 * @param channel
	 */
	public void modifyChannel(Channel channel);
	
	/**
	 * <p>
	 * 删除栏目
	 * </p>
	 * 
	 * @param ids
	 */
	public void removeChannels(String ids);
	
	/**
	 * <p>
	 * 生成栏目路径（树形结构）
	 * </p>
	 *
	 */
	public void genChannelPath();
	
	/**
	 * <p>
	 * 生成栏目路径（树形结构）
	 * </p>
	 *
	 */
	public void genChannelPath(String domain);
	
	/**
	 * <p>
	 * 返回指定栏目ID下最后一个子栏目
	 * </p>
	 * 
	 * @param pid
	 * @return
	 */
	public Channel getLastChannel(String pid);
	
	/**
	 * <p>
	 * 栏目排序
	 * </p>
	 * 
	 * @param pid
	 * @param opt
	 * @param ids
	 */
	public void sort(String pid, String opt, String ids);
	
	/**
	 * <p>
	 * 根据栏目路径返回栏目的导航信息
	 * </p>
	 * 
	 * @param path
	 * @return
	 */
	public List<Channel> getLocation(String path);
	
	/**
	 * <p>
	 * 返回子栏目列表
	 * </p>
	 * 
	 * @param id
	 * @return
	 */
	public List<Channel> getChildren(String id);
	
	/**
	 * <p>
	 * 返回全部子栏目的ID列表（包含所有下级子栏目）
	 * </p>
	 * 
	 * @param id
	 * @return
	 */
	public List<String> getChildrenIds(String id);
	
	/**
	 * <p>
	 * 返回原栏目信息，主要用于站点备份
	 * </p>
	 * 
	 * @param domain
	 * @return
	 */
	public List<Record> getBackChannels(String domain);
	
	/**
	 * <p>
	 * 删除全部栏目
	 * </p>
	 * 
	 * @param domain
	 */
	public void removeAllChannels(String domain);
	
	/**
	 * <p>
	 * 删除指定栏目的静态页面
	 * </p>
	 * 
	 * @param ids
	 */
	public void removeStaticPage(String ids);
	
	/**
	 * <p>
	 * 生成指定栏目的静态页面
	 * </p>
	 * 
	 * @param ids
	 */
	public void genStaticPage(String ids);
	
	/**
	 * <p>
	 * 生成指定栏目的静态页面，按照每页条数分页生成
	 * </p>
	 * 
	 * @param ids
	 */
	public void genStaticPage(String ids, Integer pageSize);
	
	/**
	 * <p>
	 * 返回指定栏目的文章总数
	 * </p>
	 * 
	 * @param id
	 * @return
	 */
	public Integer getContentSize(String id);
	
	/**
	 * <p>
	 * 返回允许投稿的栏目列表
	 * </p>
	 * 
	 * @return
	 */
	List<Record> getConbtChannels();

}