package itez.plat.site.service;

import java.io.File;
import java.io.IOException;

import itez.core.runtime.service.IModelService;
import itez.kit.restful.EMap;
import itez.plat.site.model.Backup;

/**
 * 由JWinner Service Generator自动生成。
 */
public interface BackupService extends IModelService<Backup>{

	/**
	 * <p>
	 * 根据备份名称返回备份记录
	 * 主要用于判断备份名称的唯一性
	 * </p>
	 * 
	 * @param caption
	 * @return
	 */
	Backup getByCaption(String caption);
	
	/**
	 * <p>
	 * 创建新备份
	 * </p>
	 * 
	 * @param bak
	 */
	void create(Backup bak);
	
	/**
	 * <p>
	 * 删除备份
	 * </p>
	 * 
	 * @param ids
	 */
	void removeBak(String ids);
	
	/**
	 * <p>
	 * 压缩备份目录，并返回完整路径用于下载
	 * </p>
	 * 
	 * @param id
	 * @return
	 */
	File zip(String id);
	
	/**
	 * <p>
	 * 上传备份文件
	 * </p>
	 * 
	 * @param file
	 * @throws IOException
	 */
	public void upload(File file) throws IOException;
	
	/**
	 * <p>
	 * 还原
	 * </p>
	 * 
	 * @param id 备份记录ID
	 * @param fileScope 还原范围：文件
	 * @param dataScope 还原范围：数据
	 * @param chnRep 是否覆盖已存在的栏目
	 * @param conRep 是否覆盖已存在的文章
	 * @param tagRep 是否覆盖已存在的标签
	 * @param navRep 是否覆盖已存在的导航
	 */
	void restore(EMap paras);

}