package itez.plat.site.model;

import java.util.List;

import com.jfinal.plugin.activerecord.Page;

import itez.core.runtime.service.Ioc;
import itez.plat.site.model.base.BaseTags;
import itez.plat.site.service.ContentService;
import itez.plat.site.service.TagsService;

/**
 * 由JWinner Model Generator自动生成。
 */
@SuppressWarnings("serial")
public class Tags extends BaseTags<Tags> {

	private transient final static TagsService tagSer = Ioc.get(TagsService.class);
	private transient final static ContentService contentSer = Ioc.get(ContentService.class);
	
	/**
	 * <p>
	 * 根据别名返回标签（站内）
	 * </p>
	 * 
	 * @param code
	 * @return
	 */
	public Tags by(String code){
		return tagSer.findByCode(code);
	}
	
	/**
	 * <p>
	 * 返回当前标签的头几篇文章（站内）
	 * </p>
	 * 
	 * @param count 返回文章条数
	 * @param desc 是否倒序（true：倒叙，false：正序）
	 * @return
	 */
	public List<Content> list(Integer count, boolean desc){
		return contentSer.queryByTag(getCode(), null, count, desc, true);
	}
	
	/**
	 * <p>
	 * 搜索当前标签内的文章（站内）
	 * </p>
	 * 
	 * @param keyword 关键字
	 * @param desc 是否倒序
	 * @return
	 */
	public List<Content> search(String keyword, boolean desc){
		return contentSer.queryByTag(getCode(), keyword, null, desc, true);
	}
	
	/**
	 * <p>
	 * 返回当前标签的指定页码的文章列表（站内）
	 * </p>
	 * 
	 * @param pageNum 页码
	 * @param pageSize 每页文章条数
	 * @param desc 是否倒序
	 * @return
	 */
	public Page<Content> page(int pageNum, int pageSize, boolean desc){
		return contentSer.queryPageByTag(getCode(), pageNum, pageSize, desc, true);
	}

	/**
	 * <p>
	 * 返回指定标签的头几篇文章（站内）
	 * </p>
	 * 
	 * @param codes 标签别名（多个别名时中间用逗号分隔）
	 * @param count 返回文章条数
	 * @param desc 是否倒序（true：倒序，false：正序）
	 * @return
	 */
	public List<Content> list(String codes, Integer count, boolean desc){
		return contentSer.queryByTag(codes, null, count, desc, true);
	}
	
	/**
	 * <p>
	 * 搜索指定标签的文章（站内）
	 * </p>
	 * 
	 * @param codes 栏目别名（多个别名时中间用逗号分隔）
	 * @param keyword 关键字
	 * @param desc 是否倒序
	 * @return
	 */
	public List<Content> search(String codes, String keyword, boolean desc){
		return contentSer.queryByTag(codes, keyword, null, desc, true);
	}
	
	/**
	 * <p>
	 * 返回指定标签的指定页码的文章列表（站内）
	 * </p>
	 * 
	 * @param codes 栏目别名（多个别名时中间用逗号分隔）
	 * @param pageNum 页码
	 * @param pageSize 每页条数
	 * @param desc 是否倒序
	 * @return
	 */
	public Page<Content> page(String codes, int pageNum, int pageSize, boolean desc){
		return contentSer.queryPageByTag(codes, pageNum, pageSize, desc, true);
	}
	
	/**
	 * <p>
	 * 根据别名返回标签（跨站）
	 * </p>
	 * 
	 * @param code
	 * @return
	 */
	public Tags byAll(String code){
		return tagSer.findByCodeAll(code);
	}
	
	/**
	 * <p>
	 * 返回当前标签的头几篇文章（跨站）
	 * </p>
	 * 
	 * @param count 返回文章条数
	 * @param desc 是否倒序（true：倒叙，false：正序）
	 * @return
	 */
	public List<Content> listAll(Integer count, boolean desc){
		return contentSer.queryByTag(getCode(), null, count, desc, false);
	}
	
	/**
	 * <p>
	 * 搜索当前标签内的文章（跨站）
	 * </p>
	 * 
	 * @param keyword 关键字
	 * @param desc 是否倒序
	 * @return
	 */
	public List<Content> searchAll(String keyword, boolean desc){
		return contentSer.queryByTag(getCode(), keyword, null, desc, false);
	}
	
	/**
	 * <p>
	 * 返回当前标签的指定页码的文章列表（跨站）
	 * </p>
	 * 
	 * @param pageNum 页码
	 * @param pageSize 每页文章条数
	 * @param desc 是否倒序
	 * @return
	 */
	public Page<Content> pageAll(int pageNum, int pageSize, boolean desc){
		return contentSer.queryPageByTag(getCode(), pageNum, pageSize, desc, false);
	}

	/**
	 * <p>
	 * 返回指定标签的头几篇文章（跨站）
	 * </p>
	 * 
	 * @param codes 标签别名（多个别名时中间用逗号分隔）
	 * @param count 返回文章条数
	 * @param desc 是否倒序（true：倒序，false：正序）
	 * @return
	 */
	public List<Content> listAll(String codes, Integer count, boolean desc){
		return contentSer.queryByTag(codes, null, count, desc, false);
	}
	
	/**
	 * <p>
	 * 搜索指定标签的文章（跨站）
	 * </p>
	 * 
	 * @param codes 栏目别名（多个别名时中间用逗号分隔）
	 * @param keyword 关键字
	 * @param desc 是否倒序
	 * @return
	 */
	public List<Content> searchAll(String codes, String keyword, boolean desc){
		return contentSer.queryByTag(codes, keyword, null, desc, false);
	}
	
	/**
	 * <p>
	 * 返回指定标签的指定页码的文章列表（跨站）
	 * </p>
	 * 
	 * @param codes 栏目别名（多个别名时中间用逗号分隔）
	 * @param pageNum 页码
	 * @param pageSize 每页条数
	 * @param desc 是否倒序
	 * @return
	 */
	public Page<Content> pageAll(String codes, int pageNum, int pageSize, boolean desc){
		return contentSer.queryPageByTag(codes, pageNum, pageSize, desc, false);
	}
	
}
