package itez.plat.site.model;

import itez.core.runtime.EContext;
import itez.core.runtime.service.Ioc;
import itez.kit.EStr;
import itez.plat.main.model.Counter;
import itez.plat.site.bean.SiteTempEngine;
import itez.plat.site.bean.SiteTempEngine.Type;
import itez.plat.site.model.base.BaseInfo;
import itez.plat.site.service.ChannelService;

/**
 * 由JWinner Model Generator自动生成。
 */
@SuppressWarnings("serial")
public class Info extends BaseInfo<Info> {

	private transient final static ChannelService channelSer = Ioc.get(ChannelService.class);
	
	/**
	 * <p>
	 * 返回网站首页地址
	 * </p>
	 * 
	 * @return
	 */
	public String url(){
		if(getGenMode() == 0){ //动态
			return dynamicUrl();
		}else if(getGenMode() == 1){ //自动静态
			return domainUrl();
		}else{ //手动静态
			return staticUrl();
		}
	}
	
	/**
	 * <p>
	 * 返回首页的动态地址
	 * </p>
	 * 
	 * @return
	 */
	public String dynamicUrl(){
		return EContext.getAttr().getSrc();
	}
	
	/**
	 * <p>
	 * 返回首页的定义地址（避免使用其他方式访问时，自动生成的静态页链接获取异常的情况）
	 * </p>
	 * 
	 * @return
	 */
	public String domainUrl(){
		return EContext.getAttr().getDomainUrl();
	}
	
	/**
	 * <p>
	 * 返回首页的静态链接地址
	 * </p>
	 * 
	 * @return
	 */
	public String staticUrl(){
		String typeName = EContext.getAttr().getItem(SiteTempEngine.SITE_PAGE_TYPE);
		Type pageType = Type.valueOf(EStr.ifEmpty(typeName, SiteTempEngine.Type.INDEX.name()));
		return pageType == Type.INDEX ? "./" : "../";
	}
	
	/**
	 * <p>
	 * 模板指令：网站访问统计
	 * 如果是动态模式，则直接显示统计结果；
	 * 否则显示空白标签占位，由 siteHandle.js 来进行动态渲染
	 * </p>
	 * 
	 * @return
	 */
	public String counter(){
		if(getGenMode() != 0) return "<span class=\"SITE-CNT-GLOBAL\">-</span>";
		return counterValue() + "";
	}

	
	/**
	 * <p>
	 * 网站访问统计总数
	 * 包含网站首页、各栏目页、各内容页的总访问数
	 * </p>
	 * 
	 * @return
	 */
	public Integer counterValue(){
		String moduleCode = itez.plat.site.ModuleConfig.MODULE_CODE;
		Channel indexChannel = channelSer.getIndexChannel();
		Counter cnt = new Counter();
		cnt.setModuleCode(moduleCode).setKey(indexChannel.getId());
		return cnt.count();
	}
	
}
