package itez.plat.site.model;

import itez.core.runtime.EContext;
import itez.core.runtime.service.Ioc;
import itez.kit.EDate;
import itez.kit.EStr;
import itez.plat.main.model.Counter;
import itez.plat.site.ModuleConfig;
import itez.plat.site.bean.SiteTempEngine;
import itez.plat.site.bean.SiteTempEngine.Type;
import itez.plat.site.model.base.BaseContent;
import itez.plat.site.service.ChannelService;
import itez.plat.site.service.ContentService;
import itez.plat.site.service.InfoService;

/**
 * 由JWinner Model Generator自动生成。
 */
@SuppressWarnings("serial")
public class Content extends BaseContent<Content> {

	private transient final static InfoService infoSer = Ioc.get(InfoService.class);
	private transient final static ChannelService channelSer = Ioc.get(ChannelService.class);
	private transient final static ContentService contentSer = Ioc.get(ContentService.class);
	
	/**
	 * <p>
	 * 返回文章地址
	 * </p>
	 * 
	 * @return
	 */
	public String url(){
		String id = getId();
		Info info = infoSer.getInfo();
		if(EStr.isEmpty(id)) return info.url();
		if(EStr.notEmpty(getLink())) return getLink();
		if(info.getGenMode() == 0){ //动态文章地址
			return dynamicUrl();
		}else if(info.getGenMode() == 1){ //自动静态文章地址
			return domainUrl();
		}else{ //手动静态文章地址
			return staticUrl(info);
		}
	}
	
	/**
	 * <p>
	 * 返回文章的动态地址
	 * </p>
	 * 
	 * @return
	 */
	public String dynamicUrl(){
		return EStr.join(EContext.getAttr().getSrc(), "/", ModuleConfig.CONTENT_ACTION, "/", getId());
	}
	
	/**
	 * <p>
	 * 返回文章的定义地址（避免使用其他方式访问时，自动生成的静态页链接获取异常的情况）
	 * </p>
	 * 
	 * @return
	 */
	public String domainUrl(){
		return EStr.join(EContext.getAttr().getDomainUrl(), "/", ModuleConfig.CONTENT_ACTION, "/", getId());
	}
	
	/**
	 * <p>
	 * 返回文章的静态页面链接地址
	 * </p>
	 * 
	 * @return
	 */
	public String staticUrl(Info info){
		String id = getId();
		Channel channel = channel();
		if(null == channel) return info.url();
		String typeName = EContext.getAttr().getItem(SiteTempEngine.SITE_PAGE_TYPE);
		Type pageType = Type.valueOf(EStr.ifEmpty(typeName, SiteTempEngine.Type.INDEX.name()));
		String url = EStr.join("/", channel.getCode(), "/", id, ".html");
		return pageType == Type.INDEX ? "." + url : ".." + url;
	}
	
	/**
	 * <p>
	 * 模板指令：文字访问统计
	 * 如果是动态模式，则直接显示统计结果；
	 * 否则显示空白标签占位，由 siteHandle.js 来进行动态渲染
	 * </p>
	 * 
	 * @return
	 */
	public String counter(){
		Info info = infoSer.getInfo();
		if(info.getGenMode() != 0) return "<span class=\"SITE-CNT-CONTENT\">-</span>";
		return counterValue() + "";
	}
	
	/**
	 * <p>
	 * 文章访问统计总数
	 * </p>
	 * 
	 * @return
	 */
	public Integer counterValue(){
		String id = getId();
		if(EStr.isEmpty(id)) return 0;
		String moduleCode = itez.plat.site.ModuleConfig.MODULE_CODE;
		Counter cnt = new Counter();
		cnt.setModuleCode(moduleCode).setKey(id);
		return cnt.count();
	}
	
	/**
	 * <p>
	 * 按ID返回文章
	 * </p>
	 * 
	 * @param id
	 * @return
	 */
	public Content by(String id){
		Content cont = contentSer.findById(id);
		if(null == cont){
			cont = new Content().setId(id).setCaption("文章不存在！");
		}
		return cont;
	}
	
	/**
	 * <p>
	 * 栏目内的下一篇文章
	 * </p>
	 * 
	 * @return
	 */
	public Content next(){
		if(EStr.isEmpty(getId())) return null;
		return contentSer.next(getChannelId(), getSort(), getCdate());
	}
	
	/**
	 * <p>
	 * 栏目内的上一篇文章
	 * </p>
	 * 
	 * @return
	 */
	public Content prev(){
		return this.previous();
	}
	
	/**
	 * <p>
	 * 栏目内的上一篇文章
	 * </p>
	 * 
	 * @return
	 */
	public Content previous(){
		if(EStr.isEmpty(getId())) return null;
		return contentSer.previous(getChannelId(), getSort(), getCdate());
	}
	
	/**
	 * <p>
	 * 返回文章所在栏目
	 * </p>
	 * 
	 * @return
	 */
	public Channel channel(){
		if(EStr.isEmpty(getChannelId())) return null;
		return channelSer.findById(getChannelId());
	}
	
	@Override
	public String getContent() {
		if(EStr.notEmpty(getValidFrom()) && getValidFrom().compareTo(EDate.getDate()) == 1){
			return "抱歉，还未到文章设置的有效期（" + getValidFrom() + "），目前无法访问！";
		}else if(EStr.notEmpty(getValidEnd()) && getValidEnd().compareTo(EDate.getDate()) == -1){
			return "抱歉，已超过文章设置的有效期（" + getValidEnd() + "），目前无法访问！";
		}
		return super.getContent();
	}
	
}
