package itez.plat.site.model;

import java.util.List;
import java.util.stream.Collectors;

import com.jfinal.plugin.activerecord.Page;

import itez.core.runtime.EContext;
import itez.core.runtime.service.Ioc;
import itez.kit.EStr;
import itez.kit.EUid;
import itez.plat.main.model.Counter;
import itez.plat.site.ModuleConfig;
import itez.plat.site.bean.SiteTempEngine;
import itez.plat.site.bean.SiteTempEngine.Type;
import itez.plat.site.model.base.BaseChannel;
import itez.plat.site.service.ChannelService;
import itez.plat.site.service.ContentService;
import itez.plat.site.service.InfoService;

/**
 * 由JWinner Model Generator自动生成。
 */
@SuppressWarnings("serial")
public class Channel extends BaseChannel<Channel> {

	private transient final static InfoService infoSer = Ioc.get(InfoService.class);
	private transient final static ChannelService channelSer = Ioc.get(ChannelService.class);
	private transient final static ContentService contentSer = Ioc.get(ContentService.class);
	
	/**
	 * <p>
	 * 返回栏目地址
	 * </p>
	 * 
	 * @return
	 */
	public String url(){
		return url(1);
	}
	
	/**
	 * <p>
	 * 返回栏目地址
	 * </p>
	 * 
	 * @return
	 */
	public String url(Integer page){
		String code = getCode();
		Info info = infoSer.getInfo();
		if(code.equals(ModuleConfig.INDEX_CODE)){ //首页
			return info.url();
		}else if(info.getGenMode() == 0){ //动态栏目地址
			return dynamicUrl(page);
		}else if(info.getGenMode() == 1){ //自动静态栏目地址
			return domainUrl(page);
		}else{ //手动静态栏目地址
			return staticUrl(page);
		}
	}
	
	/**
	 * <p>
	 * 返回栏目的动态地址
	 * </p>
	 * 
	 * @return
	 */
	public String dynamicUrl(Integer page){
		String url = EStr.join(EContext.getAttr().getSrc(), "/", ModuleConfig.CHANNEL_ACTION, "/", getCode());
		if(EStr.notEmpty(page) && page > 1) url += "?page=" + page;
		return url;
	}
	
	/**
	 * <p>
	 * 返回栏目的定义地址（避免使用其他方式访问时，自动生成的静态页链接获取异常的情况）
	 * </p>
	 * 
	 * @return
	 */
	public String domainUrl(Integer page){
		String code = getCode();
		if(code.equals(ModuleConfig.INDEX_CODE)) return infoSer.getInfo().domainUrl();
		String url = EStr.join(EContext.getAttr().getDomainUrl(), "/", ModuleConfig.CHANNEL_ACTION, "/", getCode());
		if(EStr.notEmpty(page) && page > 1) url += "?page=" + page;
		return url;
	}
	
	/**
	 * <p>
	 * 返回栏目的静态页面地址
	 * </p>
	 * 
	 * @param page
	 * @return
	 */
	public String staticUrl(Integer page){
		String code = getCode();
		String typeName = EContext.getAttr().getItem(SiteTempEngine.SITE_PAGE_TYPE);
		Type pageType = Type.valueOf(EStr.ifEmpty(typeName, SiteTempEngine.Type.INDEX.name()));
		String htmlPage = EStr.join(code, "/", page, ".html");
		return pageType == Type.INDEX ? "./" + htmlPage : "../" + htmlPage;
	}
	
	/**
	 * <p>
	 * 模板指令：栏目访问统计
	 * 如果是动态模式，则直接显示统计结果；
	 * 否则显示空白标签占位，由 siteHandle.js 来进行动态渲染
	 * </p>
	 * 
	 * @return
	 */
	public String counter(){
		Info info = infoSer.getInfo();
		if(info.getGenMode() != 0) return "<span class=\"SITE-CNT-CHANNEL\">-</span>";
		return counterValue() + "";
	}
	
	/**
	 * <p>
	 * 栏目访问统计总数
	 * 包含当前栏目页、各子栏目页、栏目下各内容页的总访问数
	 * </p>
	 * 
	 * @return
	 */
	public Integer counterValue(){
		String moduleCode = itez.plat.site.ModuleConfig.MODULE_CODE;
		Counter cnt = new Counter();
		cnt.setModuleCode(moduleCode).setKey(getId());
		return cnt.count();
	}
	
	/**
	 * <p>
	 * 根据别名返回栏目
	 * </p>
	 * 
	 * @param code
	 * @return
	 */
	public Channel by(String code){
		Channel chn = channelSer.findByCode(code);
		if(null == chn){
			chn = new Channel().setId(EUid.generator()).setCode(code).setCaption("[" + code + "]").setUsed(0);
		}
		return chn;
	}
	
	/**
	 * <p>
	 * 返回首页栏目
	 * </p>
	 * 
	 * @return
	 */
	public Channel index(){
		return channelSer.getIndexChannel();
	}
	
	/**
	 * <p>
	 * 返回上级栏目
	 * </p>
	 * 
	 * @return
	 */
	public Channel parent(){
		String code = getCode();
		if(code.equals(ModuleConfig.INDEX_CODE))
			return null;
		else
			return channelSer.findById(getPid());
	}
	
	/**
	 * <p>
	 * 返回子栏目
	 * </p>
	 * 
	 * @return
	 */
	public List<Channel> children(){
		return channelSer.getChildren(getId());
	}
	
	/**
	 * <p>
	 * 返回栏目路径
	 * </p>
	 * 
	 * @return
	 */
	public List<Channel> location(){
		String path = getPath();
		return channelSer.getLocation(path);
	}
	
	/**
	 * <p>
	 * 返回栏目下第一篇文章
	 * </p>
	 * 
	 * @return
	 */
	public Content first(){
		return contentSer.first(getId());
	}
	
	/**
	 * <p>
	 * 返回栏目下最后一篇文章
	 * </p>
	 * 
	 * @return
	 */
	public Content last(){
		return contentSer.last(getId());
	}

	/**
	 * <p>
	 * 返回栏目内的置顶文章
	 * </p>
	 * 
	 * @return
	 */
	public List<Content> tops(){
		return contentSer.getTops(getId());
	}
	
	/**
	 * <p>
	 * 返回栏目内全部文章
	 * 注1：按倒叙返回文章列表
	 * 注2：不包含子栏目文章
	 * </p>
	 * 
	 * @return
	 */
	public List<Content> list(){
		return list(null, true, false);
	}
	
	/**
	 * <p>
	 * 返回栏目内头几篇文章
	 * 注1：按倒叙返回文章列表
	 * 注2：不包含子栏目文章
	 * </p>
	 * 
	 * @param count 返回文章条数
	 * @return
	 */
	public List<Content> list(Integer count){
		return list(count, true, false);
	}
	
	/**
	 * <p>
	 * 返回栏目内头几篇文章
	 * 注1：不包含子栏目文章
	 * </p>
	 * 
	 * @param count 返回文章条数
	 * @param desc 是否倒叙（true：倒叙，false：正序）
	 * @return
	 */
	public List<Content> list(Integer count, boolean desc){
		return list(count, desc, false);
	}
	
	/**
	 * <p>
	 * 返回栏目内头几篇文章
	 * </p>
	 * 
	 * @param count 返回文章条数
	 * @param desc 是否倒叙（true：倒叙，false：正序）
	 * @param children 是否包含子栏目
	 * @return
	 */
	public List<Content> list(Integer count, boolean desc, boolean children){
		String ids = children ? EStr.parseArray(channelSer.getChildrenIds(getId())) : getId();
		return contentSer.getByChannelId(ids, count, desc);
	}
	
	/**
	 * <p>
	 * 返回栏目内指定页码的文章列表
	 * </p>
	 * 
	 * @param pageNum 页码
	 * @param pageSize 每页文章条数
	 * @param desc 是否倒叙
	 * @param children 是否包含子栏目
	 * @return
	 */
	public Page<Content> page(int pageNum, int pageSize, boolean desc, boolean children){
		String ids = children ? EStr.parseArray(channelSer.getChildrenIds(getId())) : getId();
		return contentSer.getPageByChannelId(ids, pageNum, pageSize, desc);
	}
	
	/**
	 * <p>
	 * 搜索栏目内的文章
	 * </p>
	 * 
	 * @param keyword 关键字
	 * @param desc 是否倒叙
	 * @param children 是否包含子栏目
	 * @return
	 */
	public List<Content> search(String keyword, boolean desc, boolean children){
		String ids = children ? EStr.parseArray(channelSer.getChildrenIds(getId())) : getId();
		return contentSer.searchByChannelId(ids, keyword, desc);
	}
	
	/**
	 * <p>
	 * 返回指定栏目别名的栏目ID列表
	 * </p>
	 * 
	 * @param codes 栏目别名（多个别名时中间用逗号分隔）
	 * @param children 是否包含子栏目
	 * @return
	 */
	private String getIdsByCodes(String codes, boolean children){
		List<Channel> chns = channelSer.findByCodes(codes);
		String ids;
		if(!children){
			ids = chns.stream().map(c -> c.getId()).collect(Collectors.joining(","));
		}else{
			StringBuilder sb = new StringBuilder();
			chns.forEach(c -> {
				if(sb != null) sb.append(",");
				sb.append(EStr.parseArray(channelSer.getChildrenIds(c.getId())));
			});
			ids = sb.toString();
		}
		return ids;
	}

	/**
	 * <p>
	 * 返回指定栏目内头几篇文章
	 * </p>
	 * 
	 * @param codes 栏目别名（多个别名时中间用逗号分隔）
	 * @param count 返回文章条数
	 * @param desc 是否倒叙（true：倒叙，false：正序）
	 * @param children 是否包含子栏目
	 * @return
	 */
	public List<Content> list(String codes, Integer count, boolean desc, boolean children){
		String ids = getIdsByCodes(codes, children);
		return contentSer.getByChannelId(ids, count, desc);
	}
	
	/**
	 * <p>
	 * 返回指定栏目内指定页码的文章列表
	 * </p>
	 * 
	 * @param codes 栏目别名（多个别名时中间用逗号分隔）
	 * @param pageNum 页码
	 * @param pageSize 每页条数
	 * @param desc 是否倒叙
	 * @param children 是否包含子栏目
	 * @return
	 */
	public Page<Content> page(String codes, int pageNum, int pageSize, boolean desc, boolean children){
		String ids = getIdsByCodes(codes, children);
		return contentSer.getPageByChannelId(ids, pageNum, pageSize, desc);
	}
	
	/**
	 * <p>
	 * 搜索指定栏目内的文章
	 * </p>
	 * 
	 * @param codes 栏目别名（多个别名时中间用逗号分隔）
	 * @param keyword 关键字
	 * @param desc 是否倒叙
	 * @param children 是否包含子栏目
	 * @return
	 */
	public List<Content> search(String codes, String keyword, boolean desc, boolean children){
		String ids = getIdsByCodes(codes, children);
		return contentSer.searchByChannelId(ids, keyword, desc);
	}
	
	/**
	 * <p>
	 * 搜索指定栏目内的文章
	 * </p>
	 * 
	 * @param codes 栏目别名（多个别名时中间用逗号分隔）
	 * @param keyword 关键字
	 * @param desc 是否倒叙
	 * @param children 是否包含子栏目
	 * @param pageNum 页码
	 * @param pageSize 每页条数
	 * @return
	 */
	public Page<Content> searchPage(String codes, String keyword, boolean desc, boolean children, int pageNum, int pageSize){
		String ids = getIdsByCodes(codes, children);
		return contentSer.searchPageByChannelId(ids, keyword, desc, pageNum, pageSize);
	}
	
}
