package itez.plat.site.interceptor;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;

/**
 * <p>
 * 网站管理拦截器（暂未投入使用）
 * </p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2022年10月3日 下午8:48:45
 */
public class SiteMgrInterceptor implements Interceptor {

	private static ThreadLocal<Boolean> MGR_MODE = new ThreadLocal<>();
	
	@Override
	public void intercept(Invocation inv) {
		try {
			MGR_MODE.set(true);
			inv.invoke();
		} finally {
			MGR_MODE.remove();
		}
	}
	
	public static boolean getMgrMode(){
		Boolean mgrMode = MGR_MODE.get();
		if(null == mgrMode) return false;
		return mgrMode;
	}

}
