package itez.plat.site.controller;

import java.util.List;

import com.google.inject.Inject;

import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EStr;
import itez.plat.site.bean.SiteTemp;
import itez.plat.site.bean.SiteTempEngine;
import itez.plat.site.service.InfoService;
import itez.plat.site.service.SiteTempService;
import itez.plat.wrapper.controller.EControllerMgr;

@AuthRequire.Logined
@ControllerDefine(key = "/site/temp", summary = "网站模板", view = "/")
public class SiteTempController extends EControllerMgr {

	@Inject
	InfoService infoSer;

	@Inject
	SiteTempService tempSer;
	
	public void index(){
		List<SiteTemp> temps = tempSer.getTemps();
		setAttr("temps", temps);
		render("temp.html");
	}
	
	public void init(){
		try {
			tempSer.init();
			setFlashMsg("标准模板初始化完成！");
		} catch (Exception e) {
			setFlashMsg("标准模板初始化失败：" + e.getCause().getMessage());
		}
		redirect(attr().getCtrl());
	}
	
	public void del(String fileName){
		boolean does = tempSer.del(fileName);
		if(!does) setFlashMsg("删除失败！");
		else clearTemp(fileName);
		redirect(attr().getCtrl());
	}
	
	public void saveas(String f, String t){
		tempSer.saveas(f, t);
		redirect(attr().getCtrl());
	}
	
	public void edit(String fileName){
		String act;
		SiteTemp temp;
		if(EStr.isEmpty(fileName)){
			act = "create";
			temp = new SiteTemp();
			temp.setFileName("new.html");
			temp.setSpace(0L);
			temp.setContent("<html></html>");
		}else{
			act = "modify";
			temp = tempSer.getTemp(fileName);
		}
		setAttr("act", act);
		setAttr("temp", temp);
		render("tempContent.html");
	}
	
	public void editDo(String act, String fileName, String content){
		SiteTemp temp = new SiteTemp();
		temp.setFileName(fileName);
		temp.setContent(content);
		if(act.equals("create")){
			tempSer.create(temp);
		}else if(act.equals("modify")){
			tempSer.modify(temp);
		}
		clearTemp(fileName);
		redirect(attr().getCtrl());
	}
	
	public void clear(){
		List<SiteTemp> temps = tempSer.getTemps();
		String[] views = temps.stream().map(t -> t.getFileName()).toArray(String[]::new);
		clearTemp(views);
		setFlashMsg("网站模板缓存清理完成！");
		redirect(attr().getCtrl());
	}
	
	private void clearTemp(String...views){
		SiteTempEngine.clearTempCache(views);
	}
	
}
