/**
 * SiteTagController.java
 */
package itez.plat.site.controller;

import java.util.List;

import com.google.inject.Inject;

import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EJson;
import itez.kit.EPara;
import itez.kit.EStr;
import itez.kit.restful.Result;
import itez.plat.site.model.Tags;
import itez.plat.site.service.TagsService;
import itez.plat.wrapper.controller.EControllerMgr;

/**
 * <p>
 * 标签管理
 * </p>
 * 
 * <p>Copyright(C) 2017-2021 <a href="http://www.itez.com.cn">上游科技</a></p>
 * 
 * @author		<a href="mailto:netwild@qq.com">Z.Mingyu</a>
 * @date		2021年8月3日 下午4:48:52
 */
@ControllerDefine(key = "/site/tag", summary = "标签管理", view = "/")
public class SiteTagController extends EControllerMgr {

	@Inject
	TagsService tagSer;
	
	public void index(){
		List<Tags> tags = tagSer.selectAll();
		setAttr("tags", EJson.toJson(tags));
		render("tag.html");
	}
	
	public void formEvent(){
		EPara paras = paramPack();
		Tags tag = paras.getModel(Tags.class);
		if(EStr.isEmpty(tag.getId())){
			if(tagSer.existCode(tag.getCode(), tag.getPub())){
				renderJson(Result.fail("标签代码已存在！"));
				return;
			}
		}else{
			Tags exist = tagSer.findById(tag.getId());
			if(tag.getPub() && tag.getPub() != exist.getPub()){
				if(tagSer.existCode(tag.getCode(), tag.getId())){
					renderJson(Result.fail("无法将标签切换为跨站使用，该标签代码在其他站点已存在！"));
					return;
				}
			}
		}
		tagSer.saveOrUpdate(tag);
		renderJson(Result.success("tags", tagSer.selectAll()));
	}
	
	public void remove(String id){
		tagSer.disableByIds(id);
		renderJson(Result.success("tags", tagSer.selectAll()));
	}
	
}
